/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyValueStore
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyValueStore> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(KeyValueStore.getter(KeyValueStore::name)).setter(KeyValueStore.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(KeyValueStore.getter(KeyValueStore::id)).setter(KeyValueStore.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(KeyValueStore.getter(KeyValueStore::comment)).setter(KeyValueStore.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").unmarshallLocationName("Comment").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(KeyValueStore.getter(KeyValueStore::arn)).setter(KeyValueStore.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").unmarshallLocationName("ARN").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(KeyValueStore.getter(KeyValueStore::status)).setter(KeyValueStore.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(KeyValueStore.getter(KeyValueStore::lastModifiedTime)).setter(KeyValueStore.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").unmarshallLocationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD, COMMENT_FIELD, ARN_FIELD, STATUS_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Id", ID_FIELD);
            this.put("Comment", COMMENT_FIELD);
            this.put("ARN", ARN_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String id;
    private final String comment;
    private final String arn;
    private final String status;
    private final Instant lastModifiedTime;

    private KeyValueStore(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.comment = builder.comment;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final String comment() {
        return this.comment;
    }

    public final String arn() {
        return this.arn;
    }

    public final String status() {
        return this.status;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyValueStore)) {
            return false;
        }
        KeyValueStore other = (KeyValueStore)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"KeyValueStore").add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("Comment", (Object)this.comment()).add("ARN", (Object)this.arn()).add("Status", (Object)this.status()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KeyValueStore, T> g) {
        return obj -> g.apply((KeyValueStore)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String id;
        private String comment;
        private String arn;
        private String status;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyValueStore model) {
            this.name(model.name);
            this.id(model.id);
            this.comment(model.comment);
            this.arn(model.arn);
            this.status(model.status);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public KeyValueStore build() {
            return new KeyValueStore(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyValueStore> {
        public Builder name(String var1);

        public Builder id(String var1);

        public Builder comment(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

