/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.OriginAccessControlConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOriginAccessControlRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, CreateOriginAccessControlRequest> {
    private static final SdkField<OriginAccessControlConfig> ORIGIN_ACCESS_CONTROL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginAccessControlConfig").getter(CreateOriginAccessControlRequest.getter(CreateOriginAccessControlRequest::originAccessControlConfig)).setter(CreateOriginAccessControlRequest.setter(Builder::originAccessControlConfig)).constructor(OriginAccessControlConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginAccessControlConfig").unmarshallLocationName("OriginAccessControlConfig").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_ACCESS_CONTROL_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OriginAccessControlConfig", ORIGIN_ACCESS_CONTROL_CONFIG_FIELD);
        }
    });
    private final OriginAccessControlConfig originAccessControlConfig;

    private CreateOriginAccessControlRequest(BuilderImpl builder) {
        super(builder);
        this.originAccessControlConfig = builder.originAccessControlConfig;
    }

    public final OriginAccessControlConfig originAccessControlConfig() {
        return this.originAccessControlConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.originAccessControlConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOriginAccessControlRequest)) {
            return false;
        }
        CreateOriginAccessControlRequest other = (CreateOriginAccessControlRequest)((Object)obj);
        return Objects.equals(this.originAccessControlConfig(), other.originAccessControlConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOriginAccessControlRequest").add("OriginAccessControlConfig", (Object)this.originAccessControlConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OriginAccessControlConfig": {
                return Optional.ofNullable(clazz.cast(this.originAccessControlConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateOriginAccessControlRequest, T> g) {
        return obj -> g.apply((CreateOriginAccessControlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private OriginAccessControlConfig originAccessControlConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOriginAccessControlRequest model) {
            super(model);
            this.originAccessControlConfig(model.originAccessControlConfig);
        }

        public final OriginAccessControlConfig.Builder getOriginAccessControlConfig() {
            return this.originAccessControlConfig != null ? this.originAccessControlConfig.toBuilder() : null;
        }

        public final void setOriginAccessControlConfig(OriginAccessControlConfig.BuilderImpl originAccessControlConfig) {
            this.originAccessControlConfig = originAccessControlConfig != null ? originAccessControlConfig.build() : null;
        }

        @Override
        public final Builder originAccessControlConfig(OriginAccessControlConfig originAccessControlConfig) {
            this.originAccessControlConfig = originAccessControlConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOriginAccessControlRequest build() {
            return new CreateOriginAccessControlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOriginAccessControlRequest> {
        public Builder originAccessControlConfig(OriginAccessControlConfig var1);

        default public Builder originAccessControlConfig(Consumer<OriginAccessControlConfig.Builder> originAccessControlConfig) {
            return this.originAccessControlConfig((OriginAccessControlConfig)((OriginAccessControlConfig.Builder)OriginAccessControlConfig.builder().applyMutation(originAccessControlConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

