/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetSummary;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse;

public class ListChangeSetsPublisher
implements SdkPublisher<ListChangeSetsResponse> {
    private final CloudFormationAsyncClient client;
    private final ListChangeSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChangeSetsPublisher(CloudFormationAsyncClient client, ListChangeSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChangeSetsPublisher(CloudFormationAsyncClient client, ListChangeSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChangeSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChangeSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ChangeSetSummary> summaries() {
        Function<ListChangeSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListChangeSetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListChangeSetsResponseFetcher
    implements AsyncPageFetcher<ListChangeSetsResponse> {
        private ListChangeSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListChangeSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChangeSetsResponse> nextPage(ListChangeSetsResponse previousPage) {
            if (previousPage == null) {
                return ListChangeSetsPublisher.this.client.listChangeSets(ListChangeSetsPublisher.this.firstRequest);
            }
            return ListChangeSetsPublisher.this.client.listChangeSets((ListChangeSetsRequest)((Object)ListChangeSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

