/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttributeUpdate;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttributeUpdateListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFacetRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, UpdateFacetRequest> {
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaArn").getter(UpdateFacetRequest.getter(UpdateFacetRequest::schemaArn)).setter(UpdateFacetRequest.setter(Builder::schemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateFacetRequest.getter(UpdateFacetRequest::name)).setter(UpdateFacetRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<FacetAttributeUpdate>> ATTRIBUTE_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeUpdates").getter(UpdateFacetRequest.getter(UpdateFacetRequest::attributeUpdates)).setter(UpdateFacetRequest.setter(Builder::attributeUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FacetAttributeUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OBJECT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectType").getter(UpdateFacetRequest.getter(UpdateFacetRequest::objectTypeAsString)).setter(UpdateFacetRequest.setter(Builder::objectType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ARN_FIELD, NAME_FIELD, ATTRIBUTE_UPDATES_FIELD, OBJECT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("x-amz-data-partition", SCHEMA_ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("AttributeUpdates", ATTRIBUTE_UPDATES_FIELD);
            this.put("ObjectType", OBJECT_TYPE_FIELD);
        }
    });
    private final String schemaArn;
    private final String name;
    private final List<FacetAttributeUpdate> attributeUpdates;
    private final String objectType;

    private UpdateFacetRequest(BuilderImpl builder) {
        super(builder);
        this.schemaArn = builder.schemaArn;
        this.name = builder.name;
        this.attributeUpdates = builder.attributeUpdates;
        this.objectType = builder.objectType;
    }

    public final String schemaArn() {
        return this.schemaArn;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasAttributeUpdates() {
        return this.attributeUpdates != null && !(this.attributeUpdates instanceof SdkAutoConstructList);
    }

    public final List<FacetAttributeUpdate> attributeUpdates() {
        return this.attributeUpdates;
    }

    public final ObjectType objectType() {
        return ObjectType.fromValue(this.objectType);
    }

    public final String objectTypeAsString() {
        return this.objectType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeUpdates() ? this.attributeUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFacetRequest)) {
            return false;
        }
        UpdateFacetRequest other = (UpdateFacetRequest)((Object)obj);
        return Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.name(), other.name()) && this.hasAttributeUpdates() == other.hasAttributeUpdates() && Objects.equals(this.attributeUpdates(), other.attributeUpdates()) && Objects.equals(this.objectTypeAsString(), other.objectTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFacetRequest").add("SchemaArn", (Object)this.schemaArn()).add("Name", (Object)this.name()).add("AttributeUpdates", this.hasAttributeUpdates() ? this.attributeUpdates() : null).add("ObjectType", (Object)this.objectTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaArn": {
                return Optional.ofNullable(clazz.cast(this.schemaArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AttributeUpdates": {
                return Optional.ofNullable(clazz.cast(this.attributeUpdates()));
            }
            case "ObjectType": {
                return Optional.ofNullable(clazz.cast(this.objectTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFacetRequest, T> g) {
        return obj -> g.apply((UpdateFacetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String schemaArn;
        private String name;
        private List<FacetAttributeUpdate> attributeUpdates = DefaultSdkAutoConstructList.getInstance();
        private String objectType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFacetRequest model) {
            super(model);
            this.schemaArn(model.schemaArn);
            this.name(model.name);
            this.attributeUpdates(model.attributeUpdates);
            this.objectType(model.objectType);
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<FacetAttributeUpdate.Builder> getAttributeUpdates() {
            List<FacetAttributeUpdate.Builder> result = FacetAttributeUpdateListCopier.copyToBuilder(this.attributeUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeUpdates(Collection<FacetAttributeUpdate.BuilderImpl> attributeUpdates) {
            this.attributeUpdates = FacetAttributeUpdateListCopier.copyFromBuilder(attributeUpdates);
        }

        @Override
        public final Builder attributeUpdates(Collection<FacetAttributeUpdate> attributeUpdates) {
            this.attributeUpdates = FacetAttributeUpdateListCopier.copy(attributeUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(FacetAttributeUpdate ... attributeUpdates) {
            this.attributeUpdates(Arrays.asList(attributeUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(Consumer<FacetAttributeUpdate.Builder> ... attributeUpdates) {
            this.attributeUpdates(Stream.of(attributeUpdates).map(c -> (FacetAttributeUpdate)((FacetAttributeUpdate.Builder)FacetAttributeUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getObjectType() {
            return this.objectType;
        }

        public final void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        @Override
        public final Builder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        @Override
        public final Builder objectType(ObjectType objectType) {
            this.objectType(objectType == null ? null : objectType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFacetRequest build() {
            return new UpdateFacetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFacetRequest> {
        public Builder schemaArn(String var1);

        public Builder name(String var1);

        public Builder attributeUpdates(Collection<FacetAttributeUpdate> var1);

        public Builder attributeUpdates(FacetAttributeUpdate ... var1);

        public Builder attributeUpdates(Consumer<FacetAttributeUpdate.Builder> ... var1);

        public Builder objectType(String var1);

        public Builder objectType(ObjectType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

