/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmessaging.ChimeSdkMessagingClient;
import software.amazon.awssdk.services.chimesdkmessaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelBansRequest;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelBansResponse;

public class ListChannelBansIterable
implements SdkIterable<ListChannelBansResponse> {
    private final ChimeSdkMessagingClient client;
    private final ListChannelBansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChannelBansIterable(ChimeSdkMessagingClient client, ListChannelBansRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListChannelBansResponseFetcher();
    }

    public Iterator<ListChannelBansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListChannelBansResponseFetcher
    implements SyncPageFetcher<ListChannelBansResponse> {
        private ListChannelBansResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelBansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChannelBansResponse nextPage(ListChannelBansResponse previousPage) {
            if (previousPage == null) {
                return ListChannelBansIterable.this.client.listChannelBans(ListChannelBansIterable.this.firstRequest);
            }
            return ListChannelBansIterable.this.client.listChannelBans((ListChannelBansRequest)((Object)ListChannelBansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

