/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChannelMessageSummary;
import software.amazon.awssdk.services.chime.model.ChannelMessageSummaryListCopier;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChannelMessagesResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, ListChannelMessagesResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(ListChannelMessagesResponse.getter(ListChannelMessagesResponse::channelArn)).setter(ListChannelMessagesResponse.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListChannelMessagesResponse.getter(ListChannelMessagesResponse::nextToken)).setter(ListChannelMessagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ChannelMessageSummary>> CHANNEL_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelMessages").getter(ListChannelMessagesResponse.getter(ListChannelMessagesResponse::channelMessages)).setter(ListChannelMessagesResponse.setter(Builder::channelMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelMessageSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, NEXT_TOKEN_FIELD, CHANNEL_MESSAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ChannelArn", CHANNEL_ARN_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("ChannelMessages", CHANNEL_MESSAGES_FIELD);
        }
    });
    private final String channelArn;
    private final String nextToken;
    private final List<ChannelMessageSummary> channelMessages;

    private ListChannelMessagesResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.nextToken = builder.nextToken;
        this.channelMessages = builder.channelMessages;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasChannelMessages() {
        return this.channelMessages != null && !(this.channelMessages instanceof SdkAutoConstructList);
    }

    public final List<ChannelMessageSummary> channelMessages() {
        return this.channelMessages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelMessages() ? this.channelMessages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelMessagesResponse)) {
            return false;
        }
        ListChannelMessagesResponse other = (ListChannelMessagesResponse)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasChannelMessages() == other.hasChannelMessages() && Objects.equals(this.channelMessages(), other.channelMessages());
    }

    public final String toString() {
        return ToString.builder((String)"ListChannelMessagesResponse").add("ChannelArn", (Object)this.channelArn()).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).add("ChannelMessages", this.hasChannelMessages() ? this.channelMessages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ChannelMessages": {
                return Optional.ofNullable(clazz.cast(this.channelMessages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListChannelMessagesResponse, T> g) {
        return obj -> g.apply((ListChannelMessagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private String channelArn;
        private String nextToken;
        private List<ChannelMessageSummary> channelMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelMessagesResponse model) {
            super(model);
            this.channelArn(model.channelArn);
            this.nextToken(model.nextToken);
            this.channelMessages(model.channelMessages);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ChannelMessageSummary.Builder> getChannelMessages() {
            List<ChannelMessageSummary.Builder> result = ChannelMessageSummaryListCopier.copyToBuilder(this.channelMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelMessages(Collection<ChannelMessageSummary.BuilderImpl> channelMessages) {
            this.channelMessages = ChannelMessageSummaryListCopier.copyFromBuilder(channelMessages);
        }

        @Override
        public final Builder channelMessages(Collection<ChannelMessageSummary> channelMessages) {
            this.channelMessages = ChannelMessageSummaryListCopier.copy(channelMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMessages(ChannelMessageSummary ... channelMessages) {
            this.channelMessages(Arrays.asList(channelMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMessages(Consumer<ChannelMessageSummary.Builder> ... channelMessages) {
            this.channelMessages(Stream.of(channelMessages).map(c -> (ChannelMessageSummary)((ChannelMessageSummary.Builder)ChannelMessageSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListChannelMessagesResponse build() {
            return new ListChannelMessagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChannelMessagesResponse> {
        public Builder channelArn(String var1);

        public Builder nextToken(String var1);

        public Builder channelMessages(Collection<ChannelMessageSummary> var1);

        public Builder channelMessages(ChannelMessageSummary ... var1);

        public Builder channelMessages(Consumer<ChannelMessageSummary.Builder> ... var1);
    }
}

