/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.budgets.model.Action;
import software.amazon.awssdk.services.budgets.model.BudgetsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBudgetActionResponse
extends BudgetsResponse
implements ToCopyableBuilder<Builder, UpdateBudgetActionResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(UpdateBudgetActionResponse.getter(UpdateBudgetActionResponse::accountId)).setter(UpdateBudgetActionResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BudgetName").getter(UpdateBudgetActionResponse.getter(UpdateBudgetActionResponse::budgetName)).setter(UpdateBudgetActionResponse.setter(Builder::budgetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()}).build();
    private static final SdkField<Action> OLD_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OldAction").getter(UpdateBudgetActionResponse.getter(UpdateBudgetActionResponse::oldAction)).setter(UpdateBudgetActionResponse.setter(Builder::oldAction)).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OldAction").build()}).build();
    private static final SdkField<Action> NEW_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NewAction").getter(UpdateBudgetActionResponse.getter(UpdateBudgetActionResponse::newAction)).setter(UpdateBudgetActionResponse.setter(Builder::newAction)).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, BUDGET_NAME_FIELD, OLD_ACTION_FIELD, NEW_ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountId", ACCOUNT_ID_FIELD);
            this.put("BudgetName", BUDGET_NAME_FIELD);
            this.put("OldAction", OLD_ACTION_FIELD);
            this.put("NewAction", NEW_ACTION_FIELD);
        }
    });
    private final String accountId;
    private final String budgetName;
    private final Action oldAction;
    private final Action newAction;

    private UpdateBudgetActionResponse(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.oldAction = builder.oldAction;
        this.newAction = builder.newAction;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String budgetName() {
        return this.budgetName;
    }

    public final Action oldAction() {
        return this.oldAction;
    }

    public final Action newAction() {
        return this.newAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.oldAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.newAction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBudgetActionResponse)) {
            return false;
        }
        UpdateBudgetActionResponse other = (UpdateBudgetActionResponse)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.budgetName(), other.budgetName()) && Objects.equals(this.oldAction(), other.oldAction()) && Objects.equals(this.newAction(), other.newAction());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBudgetActionResponse").add("AccountId", (Object)this.accountId()).add("BudgetName", (Object)this.budgetName()).add("OldAction", (Object)this.oldAction()).add("NewAction", (Object)this.newAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "BudgetName": {
                return Optional.ofNullable(clazz.cast(this.budgetName()));
            }
            case "OldAction": {
                return Optional.ofNullable(clazz.cast(this.oldAction()));
            }
            case "NewAction": {
                return Optional.ofNullable(clazz.cast(this.newAction()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBudgetActionResponse, T> g) {
        return obj -> g.apply((UpdateBudgetActionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BudgetsResponse.BuilderImpl
    implements Builder {
        private String accountId;
        private String budgetName;
        private Action oldAction;
        private Action newAction;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBudgetActionResponse model) {
            super(model);
            this.accountId(model.accountId);
            this.budgetName(model.budgetName);
            this.oldAction(model.oldAction);
            this.newAction(model.newAction);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final Action.Builder getOldAction() {
            return this.oldAction != null ? this.oldAction.toBuilder() : null;
        }

        public final void setOldAction(Action.BuilderImpl oldAction) {
            this.oldAction = oldAction != null ? oldAction.build() : null;
        }

        @Override
        public final Builder oldAction(Action oldAction) {
            this.oldAction = oldAction;
            return this;
        }

        public final Action.Builder getNewAction() {
            return this.newAction != null ? this.newAction.toBuilder() : null;
        }

        public final void setNewAction(Action.BuilderImpl newAction) {
            this.newAction = newAction != null ? newAction.build() : null;
        }

        @Override
        public final Builder newAction(Action newAction) {
            this.newAction = newAction;
            return this;
        }

        @Override
        public UpdateBudgetActionResponse build() {
            return new UpdateBudgetActionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BudgetsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBudgetActionResponse> {
        public Builder accountId(String var1);

        public Builder budgetName(String var1);

        public Builder oldAction(Action var1);

        default public Builder oldAction(Consumer<Action.Builder> oldAction) {
            return this.oldAction((Action)((Action.Builder)Action.builder().applyMutation(oldAction)).build());
        }

        public Builder newAction(Action var1);

        default public Builder newAction(Consumer<Action.Builder> newAction) {
            return this.newAction((Action)((Action.Builder)Action.builder().applyMutation(newAction)).build());
        }
    }
}

