/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.braket.BraketClient;
import software.amazon.awssdk.services.braket.internal.UserAgentUtils;
import software.amazon.awssdk.services.braket.model.JobSummary;
import software.amazon.awssdk.services.braket.model.SearchJobsRequest;
import software.amazon.awssdk.services.braket.model.SearchJobsResponse;

public class SearchJobsIterable
implements SdkIterable<SearchJobsResponse> {
    private final BraketClient client;
    private final SearchJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchJobsIterable(BraketClient client, SearchJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchJobsResponseFetcher();
    }

    public Iterator<SearchJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobSummary> jobs() {
        Function<SearchJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchJobsResponseFetcher
    implements SyncPageFetcher<SearchJobsResponse> {
        private SearchJobsResponseFetcher() {
        }

        public boolean hasNextPage(SearchJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchJobsResponse nextPage(SearchJobsResponse previousPage) {
            if (previousPage == null) {
                return SearchJobsIterable.this.client.searchJobs(SearchJobsIterable.this.firstRequest);
            }
            return SearchJobsIterable.this.client.searchJobs((SearchJobsRequest)((Object)SearchJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

