/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorResponse;
import software.amazon.awssdk.services.billingconductor.model.PricingRuleListCopier;
import software.amazon.awssdk.services.billingconductor.model.PricingRuleListElement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPricingRulesResponse
extends BillingconductorResponse
implements ToCopyableBuilder<Builder, ListPricingRulesResponse> {
    private static final SdkField<String> BILLING_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingPeriod").getter(ListPricingRulesResponse.getter(ListPricingRulesResponse::billingPeriod)).setter(ListPricingRulesResponse.setter(Builder::billingPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriod").build()}).build();
    private static final SdkField<List<PricingRuleListElement>> PRICING_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PricingRules").getter(ListPricingRulesResponse.getter(ListPricingRulesResponse::pricingRules)).setter(ListPricingRulesResponse.setter(Builder::pricingRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PricingRuleListElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPricingRulesResponse.getter(ListPricingRulesResponse::nextToken)).setter(ListPricingRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_PERIOD_FIELD, PRICING_RULES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BillingPeriod", BILLING_PERIOD_FIELD);
            this.put("PricingRules", PRICING_RULES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String billingPeriod;
    private final List<PricingRuleListElement> pricingRules;
    private final String nextToken;

    private ListPricingRulesResponse(BuilderImpl builder) {
        super(builder);
        this.billingPeriod = builder.billingPeriod;
        this.pricingRules = builder.pricingRules;
        this.nextToken = builder.nextToken;
    }

    public final String billingPeriod() {
        return this.billingPeriod;
    }

    public final boolean hasPricingRules() {
        return this.pricingRules != null && !(this.pricingRules instanceof SdkAutoConstructList);
    }

    public final List<PricingRuleListElement> pricingRules() {
        return this.pricingRules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.billingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPricingRules() ? this.pricingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPricingRulesResponse)) {
            return false;
        }
        ListPricingRulesResponse other = (ListPricingRulesResponse)((Object)obj);
        return Objects.equals(this.billingPeriod(), other.billingPeriod()) && this.hasPricingRules() == other.hasPricingRules() && Objects.equals(this.pricingRules(), other.pricingRules()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPricingRulesResponse").add("BillingPeriod", (Object)this.billingPeriod()).add("PricingRules", this.hasPricingRules() ? this.pricingRules() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BillingPeriod": {
                return Optional.ofNullable(clazz.cast(this.billingPeriod()));
            }
            case "PricingRules": {
                return Optional.ofNullable(clazz.cast(this.pricingRules()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPricingRulesResponse, T> g) {
        return obj -> g.apply((ListPricingRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorResponse.BuilderImpl
    implements Builder {
        private String billingPeriod;
        private List<PricingRuleListElement> pricingRules = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPricingRulesResponse model) {
            super(model);
            this.billingPeriod(model.billingPeriod);
            this.pricingRules(model.pricingRules);
            this.nextToken(model.nextToken);
        }

        public final String getBillingPeriod() {
            return this.billingPeriod;
        }

        public final void setBillingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
        }

        @Override
        public final Builder billingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        public final List<PricingRuleListElement.Builder> getPricingRules() {
            List<PricingRuleListElement.Builder> result = PricingRuleListCopier.copyToBuilder(this.pricingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPricingRules(Collection<PricingRuleListElement.BuilderImpl> pricingRules) {
            this.pricingRules = PricingRuleListCopier.copyFromBuilder(pricingRules);
        }

        @Override
        public final Builder pricingRules(Collection<PricingRuleListElement> pricingRules) {
            this.pricingRules = PricingRuleListCopier.copy(pricingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingRules(PricingRuleListElement ... pricingRules) {
            this.pricingRules(Arrays.asList(pricingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingRules(Consumer<PricingRuleListElement.Builder> ... pricingRules) {
            this.pricingRules(Stream.of(pricingRules).map(c -> (PricingRuleListElement)((PricingRuleListElement.Builder)PricingRuleListElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPricingRulesResponse build() {
            return new ListPricingRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BillingconductorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPricingRulesResponse> {
        public Builder billingPeriod(String var1);

        public Builder pricingRules(Collection<PricingRuleListElement> var1);

        public Builder pricingRules(PricingRuleListElement ... var1);

        public Builder pricingRules(Consumer<PricingRuleListElement.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

