/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backupgateway.model.DaysOfWeekCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BandwidthRateLimitInterval
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BandwidthRateLimitInterval> {
    private static final SdkField<Long> AVERAGE_UPLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AverageUploadRateLimitInBitsPerSec").getter(BandwidthRateLimitInterval.getter(BandwidthRateLimitInterval::averageUploadRateLimitInBitsPerSec)).setter(BandwidthRateLimitInterval.setter(Builder::averageUploadRateLimitInBitsPerSec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageUploadRateLimitInBitsPerSec").build()}).build();
    private static final SdkField<List<Integer>> DAYS_OF_WEEK_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DaysOfWeek").getter(BandwidthRateLimitInterval.getter(BandwidthRateLimitInterval::daysOfWeek)).setter(BandwidthRateLimitInterval.setter(Builder::daysOfWeek)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DaysOfWeek").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> END_HOUR_OF_DAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndHourOfDay").getter(BandwidthRateLimitInterval.getter(BandwidthRateLimitInterval::endHourOfDay)).setter(BandwidthRateLimitInterval.setter(Builder::endHourOfDay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndHourOfDay").build()}).build();
    private static final SdkField<Integer> END_MINUTE_OF_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndMinuteOfHour").getter(BandwidthRateLimitInterval.getter(BandwidthRateLimitInterval::endMinuteOfHour)).setter(BandwidthRateLimitInterval.setter(Builder::endMinuteOfHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndMinuteOfHour").build()}).build();
    private static final SdkField<Integer> START_HOUR_OF_DAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StartHourOfDay").getter(BandwidthRateLimitInterval.getter(BandwidthRateLimitInterval::startHourOfDay)).setter(BandwidthRateLimitInterval.setter(Builder::startHourOfDay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartHourOfDay").build()}).build();
    private static final SdkField<Integer> START_MINUTE_OF_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StartMinuteOfHour").getter(BandwidthRateLimitInterval.getter(BandwidthRateLimitInterval::startMinuteOfHour)).setter(BandwidthRateLimitInterval.setter(Builder::startMinuteOfHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartMinuteOfHour").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVERAGE_UPLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD, DAYS_OF_WEEK_FIELD, END_HOUR_OF_DAY_FIELD, END_MINUTE_OF_HOUR_FIELD, START_HOUR_OF_DAY_FIELD, START_MINUTE_OF_HOUR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AverageUploadRateLimitInBitsPerSec", AVERAGE_UPLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD);
            this.put("DaysOfWeek", DAYS_OF_WEEK_FIELD);
            this.put("EndHourOfDay", END_HOUR_OF_DAY_FIELD);
            this.put("EndMinuteOfHour", END_MINUTE_OF_HOUR_FIELD);
            this.put("StartHourOfDay", START_HOUR_OF_DAY_FIELD);
            this.put("StartMinuteOfHour", START_MINUTE_OF_HOUR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long averageUploadRateLimitInBitsPerSec;
    private final List<Integer> daysOfWeek;
    private final Integer endHourOfDay;
    private final Integer endMinuteOfHour;
    private final Integer startHourOfDay;
    private final Integer startMinuteOfHour;

    private BandwidthRateLimitInterval(BuilderImpl builder) {
        this.averageUploadRateLimitInBitsPerSec = builder.averageUploadRateLimitInBitsPerSec;
        this.daysOfWeek = builder.daysOfWeek;
        this.endHourOfDay = builder.endHourOfDay;
        this.endMinuteOfHour = builder.endMinuteOfHour;
        this.startHourOfDay = builder.startHourOfDay;
        this.startMinuteOfHour = builder.startMinuteOfHour;
    }

    public final Long averageUploadRateLimitInBitsPerSec() {
        return this.averageUploadRateLimitInBitsPerSec;
    }

    public final boolean hasDaysOfWeek() {
        return this.daysOfWeek != null && !(this.daysOfWeek instanceof SdkAutoConstructList);
    }

    public final List<Integer> daysOfWeek() {
        return this.daysOfWeek;
    }

    public final Integer endHourOfDay() {
        return this.endHourOfDay;
    }

    public final Integer endMinuteOfHour() {
        return this.endMinuteOfHour;
    }

    public final Integer startHourOfDay() {
        return this.startHourOfDay;
    }

    public final Integer startMinuteOfHour() {
        return this.startMinuteOfHour;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.averageUploadRateLimitInBitsPerSec());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDaysOfWeek() ? this.daysOfWeek() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.endHourOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(this.endMinuteOfHour());
        hashCode = 31 * hashCode + Objects.hashCode(this.startHourOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(this.startMinuteOfHour());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BandwidthRateLimitInterval)) {
            return false;
        }
        BandwidthRateLimitInterval other = (BandwidthRateLimitInterval)obj;
        return Objects.equals(this.averageUploadRateLimitInBitsPerSec(), other.averageUploadRateLimitInBitsPerSec()) && this.hasDaysOfWeek() == other.hasDaysOfWeek() && Objects.equals(this.daysOfWeek(), other.daysOfWeek()) && Objects.equals(this.endHourOfDay(), other.endHourOfDay()) && Objects.equals(this.endMinuteOfHour(), other.endMinuteOfHour()) && Objects.equals(this.startHourOfDay(), other.startHourOfDay()) && Objects.equals(this.startMinuteOfHour(), other.startMinuteOfHour());
    }

    public final String toString() {
        return ToString.builder((String)"BandwidthRateLimitInterval").add("AverageUploadRateLimitInBitsPerSec", (Object)this.averageUploadRateLimitInBitsPerSec()).add("DaysOfWeek", this.hasDaysOfWeek() ? this.daysOfWeek() : null).add("EndHourOfDay", (Object)this.endHourOfDay()).add("EndMinuteOfHour", (Object)this.endMinuteOfHour()).add("StartHourOfDay", (Object)this.startHourOfDay()).add("StartMinuteOfHour", (Object)this.startMinuteOfHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AverageUploadRateLimitInBitsPerSec": {
                return Optional.ofNullable(clazz.cast(this.averageUploadRateLimitInBitsPerSec()));
            }
            case "DaysOfWeek": {
                return Optional.ofNullable(clazz.cast(this.daysOfWeek()));
            }
            case "EndHourOfDay": {
                return Optional.ofNullable(clazz.cast(this.endHourOfDay()));
            }
            case "EndMinuteOfHour": {
                return Optional.ofNullable(clazz.cast(this.endMinuteOfHour()));
            }
            case "StartHourOfDay": {
                return Optional.ofNullable(clazz.cast(this.startHourOfDay()));
            }
            case "StartMinuteOfHour": {
                return Optional.ofNullable(clazz.cast(this.startMinuteOfHour()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BandwidthRateLimitInterval, T> g) {
        return obj -> g.apply((BandwidthRateLimitInterval)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long averageUploadRateLimitInBitsPerSec;
        private List<Integer> daysOfWeek = DefaultSdkAutoConstructList.getInstance();
        private Integer endHourOfDay;
        private Integer endMinuteOfHour;
        private Integer startHourOfDay;
        private Integer startMinuteOfHour;

        private BuilderImpl() {
        }

        private BuilderImpl(BandwidthRateLimitInterval model) {
            this.averageUploadRateLimitInBitsPerSec(model.averageUploadRateLimitInBitsPerSec);
            this.daysOfWeek(model.daysOfWeek);
            this.endHourOfDay(model.endHourOfDay);
            this.endMinuteOfHour(model.endMinuteOfHour);
            this.startHourOfDay(model.startHourOfDay);
            this.startMinuteOfHour(model.startMinuteOfHour);
        }

        public final Long getAverageUploadRateLimitInBitsPerSec() {
            return this.averageUploadRateLimitInBitsPerSec;
        }

        public final void setAverageUploadRateLimitInBitsPerSec(Long averageUploadRateLimitInBitsPerSec) {
            this.averageUploadRateLimitInBitsPerSec = averageUploadRateLimitInBitsPerSec;
        }

        @Override
        public final Builder averageUploadRateLimitInBitsPerSec(Long averageUploadRateLimitInBitsPerSec) {
            this.averageUploadRateLimitInBitsPerSec = averageUploadRateLimitInBitsPerSec;
            return this;
        }

        public final Collection<Integer> getDaysOfWeek() {
            if (this.daysOfWeek instanceof SdkAutoConstructList) {
                return null;
            }
            return this.daysOfWeek;
        }

        public final void setDaysOfWeek(Collection<Integer> daysOfWeek) {
            this.daysOfWeek = DaysOfWeekCopier.copy(daysOfWeek);
        }

        @Override
        public final Builder daysOfWeek(Collection<Integer> daysOfWeek) {
            this.daysOfWeek = DaysOfWeekCopier.copy(daysOfWeek);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder daysOfWeek(Integer ... daysOfWeek) {
            this.daysOfWeek(Arrays.asList(daysOfWeek));
            return this;
        }

        public final Integer getEndHourOfDay() {
            return this.endHourOfDay;
        }

        public final void setEndHourOfDay(Integer endHourOfDay) {
            this.endHourOfDay = endHourOfDay;
        }

        @Override
        public final Builder endHourOfDay(Integer endHourOfDay) {
            this.endHourOfDay = endHourOfDay;
            return this;
        }

        public final Integer getEndMinuteOfHour() {
            return this.endMinuteOfHour;
        }

        public final void setEndMinuteOfHour(Integer endMinuteOfHour) {
            this.endMinuteOfHour = endMinuteOfHour;
        }

        @Override
        public final Builder endMinuteOfHour(Integer endMinuteOfHour) {
            this.endMinuteOfHour = endMinuteOfHour;
            return this;
        }

        public final Integer getStartHourOfDay() {
            return this.startHourOfDay;
        }

        public final void setStartHourOfDay(Integer startHourOfDay) {
            this.startHourOfDay = startHourOfDay;
        }

        @Override
        public final Builder startHourOfDay(Integer startHourOfDay) {
            this.startHourOfDay = startHourOfDay;
            return this;
        }

        public final Integer getStartMinuteOfHour() {
            return this.startMinuteOfHour;
        }

        public final void setStartMinuteOfHour(Integer startMinuteOfHour) {
            this.startMinuteOfHour = startMinuteOfHour;
        }

        @Override
        public final Builder startMinuteOfHour(Integer startMinuteOfHour) {
            this.startMinuteOfHour = startMinuteOfHour;
            return this;
        }

        public BandwidthRateLimitInterval build() {
            return new BandwidthRateLimitInterval(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BandwidthRateLimitInterval> {
        public Builder averageUploadRateLimitInBitsPerSec(Long var1);

        public Builder daysOfWeek(Collection<Integer> var1);

        public Builder daysOfWeek(Integer ... var1);

        public Builder endHourOfDay(Integer var1);

        public Builder endMinuteOfHour(Integer var1);

        public Builder startHourOfDay(Integer var1);

        public Builder startMinuteOfHour(Integer var1);
    }
}

