/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsResponse;
import software.amazon.awssdk.services.backup.model.RestoreTestingSelectionForList;

public class ListRestoreTestingSelectionsPublisher
implements SdkPublisher<ListRestoreTestingSelectionsResponse> {
    private final BackupAsyncClient client;
    private final ListRestoreTestingSelectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRestoreTestingSelectionsPublisher(BackupAsyncClient client, ListRestoreTestingSelectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRestoreTestingSelectionsPublisher(BackupAsyncClient client, ListRestoreTestingSelectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRestoreTestingSelectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRestoreTestingSelectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RestoreTestingSelectionForList> restoreTestingSelections() {
        Function<ListRestoreTestingSelectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.restoreTestingSelections() != null) {
                return response.restoreTestingSelections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRestoreTestingSelectionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRestoreTestingSelectionsResponseFetcher
    implements AsyncPageFetcher<ListRestoreTestingSelectionsResponse> {
        private ListRestoreTestingSelectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListRestoreTestingSelectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRestoreTestingSelectionsResponse> nextPage(ListRestoreTestingSelectionsResponse previousPage) {
            if (previousPage == null) {
                return ListRestoreTestingSelectionsPublisher.this.client.listRestoreTestingSelections(ListRestoreTestingSelectionsPublisher.this.firstRequest);
            }
            return ListRestoreTestingSelectionsPublisher.this.client.listRestoreTestingSelections((ListRestoreTestingSelectionsRequest)((Object)ListRestoreTestingSelectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

