/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.internal.UserAgentUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse;

public class DescribeLoadBalancerTargetGroupsIterable
implements SdkIterable<DescribeLoadBalancerTargetGroupsResponse> {
    private final AutoScalingClient client;
    private final DescribeLoadBalancerTargetGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeLoadBalancerTargetGroupsIterable(AutoScalingClient client, DescribeLoadBalancerTargetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeLoadBalancerTargetGroupsResponseFetcher();
    }

    public Iterator<DescribeLoadBalancerTargetGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeLoadBalancerTargetGroupsResponseFetcher
    implements SyncPageFetcher<DescribeLoadBalancerTargetGroupsResponse> {
        private DescribeLoadBalancerTargetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLoadBalancerTargetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeLoadBalancerTargetGroupsResponse nextPage(DescribeLoadBalancerTargetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeLoadBalancerTargetGroupsIterable.this.client.describeLoadBalancerTargetGroups(DescribeLoadBalancerTargetGroupsIterable.this.firstRequest);
            }
            return DescribeLoadBalancerTargetGroupsIterable.this.client.describeLoadBalancerTargetGroups((DescribeLoadBalancerTargetGroupsRequest)((Object)DescribeLoadBalancerTargetGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

