/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.AppSyncResponse;
import software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionResult;
import software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataSourceIntrospectionResponse
extends AppSyncResponse
implements ToCopyableBuilder<Builder, GetDataSourceIntrospectionResponse> {
    private static final SdkField<String> INTROSPECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("introspectionId").getter(GetDataSourceIntrospectionResponse.getter(GetDataSourceIntrospectionResponse::introspectionId)).setter(GetDataSourceIntrospectionResponse.setter(Builder::introspectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("introspectionId").build()}).build();
    private static final SdkField<String> INTROSPECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("introspectionStatus").getter(GetDataSourceIntrospectionResponse.getter(GetDataSourceIntrospectionResponse::introspectionStatusAsString)).setter(GetDataSourceIntrospectionResponse.setter(Builder::introspectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("introspectionStatus").build()}).build();
    private static final SdkField<String> INTROSPECTION_STATUS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("introspectionStatusDetail").getter(GetDataSourceIntrospectionResponse.getter(GetDataSourceIntrospectionResponse::introspectionStatusDetail)).setter(GetDataSourceIntrospectionResponse.setter(Builder::introspectionStatusDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("introspectionStatusDetail").build()}).build();
    private static final SdkField<DataSourceIntrospectionResult> INTROSPECTION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("introspectionResult").getter(GetDataSourceIntrospectionResponse.getter(GetDataSourceIntrospectionResponse::introspectionResult)).setter(GetDataSourceIntrospectionResponse.setter(Builder::introspectionResult)).constructor(DataSourceIntrospectionResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("introspectionResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTROSPECTION_ID_FIELD, INTROSPECTION_STATUS_FIELD, INTROSPECTION_STATUS_DETAIL_FIELD, INTROSPECTION_RESULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("introspectionId", INTROSPECTION_ID_FIELD);
            this.put("introspectionStatus", INTROSPECTION_STATUS_FIELD);
            this.put("introspectionStatusDetail", INTROSPECTION_STATUS_DETAIL_FIELD);
            this.put("introspectionResult", INTROSPECTION_RESULT_FIELD);
        }
    });
    private final String introspectionId;
    private final String introspectionStatus;
    private final String introspectionStatusDetail;
    private final DataSourceIntrospectionResult introspectionResult;

    private GetDataSourceIntrospectionResponse(BuilderImpl builder) {
        super(builder);
        this.introspectionId = builder.introspectionId;
        this.introspectionStatus = builder.introspectionStatus;
        this.introspectionStatusDetail = builder.introspectionStatusDetail;
        this.introspectionResult = builder.introspectionResult;
    }

    public final String introspectionId() {
        return this.introspectionId;
    }

    public final DataSourceIntrospectionStatus introspectionStatus() {
        return DataSourceIntrospectionStatus.fromValue(this.introspectionStatus);
    }

    public final String introspectionStatusAsString() {
        return this.introspectionStatus;
    }

    public final String introspectionStatusDetail() {
        return this.introspectionStatusDetail;
    }

    public final DataSourceIntrospectionResult introspectionResult() {
        return this.introspectionResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.introspectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.introspectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.introspectionStatusDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.introspectionResult());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSourceIntrospectionResponse)) {
            return false;
        }
        GetDataSourceIntrospectionResponse other = (GetDataSourceIntrospectionResponse)((Object)obj);
        return Objects.equals(this.introspectionId(), other.introspectionId()) && Objects.equals(this.introspectionStatusAsString(), other.introspectionStatusAsString()) && Objects.equals(this.introspectionStatusDetail(), other.introspectionStatusDetail()) && Objects.equals(this.introspectionResult(), other.introspectionResult());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataSourceIntrospectionResponse").add("IntrospectionId", (Object)this.introspectionId()).add("IntrospectionStatus", (Object)this.introspectionStatusAsString()).add("IntrospectionStatusDetail", (Object)this.introspectionStatusDetail()).add("IntrospectionResult", (Object)this.introspectionResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "introspectionId": {
                return Optional.ofNullable(clazz.cast(this.introspectionId()));
            }
            case "introspectionStatus": {
                return Optional.ofNullable(clazz.cast(this.introspectionStatusAsString()));
            }
            case "introspectionStatusDetail": {
                return Optional.ofNullable(clazz.cast(this.introspectionStatusDetail()));
            }
            case "introspectionResult": {
                return Optional.ofNullable(clazz.cast(this.introspectionResult()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDataSourceIntrospectionResponse, T> g) {
        return obj -> g.apply((GetDataSourceIntrospectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncResponse.BuilderImpl
    implements Builder {
        private String introspectionId;
        private String introspectionStatus;
        private String introspectionStatusDetail;
        private DataSourceIntrospectionResult introspectionResult;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSourceIntrospectionResponse model) {
            super(model);
            this.introspectionId(model.introspectionId);
            this.introspectionStatus(model.introspectionStatus);
            this.introspectionStatusDetail(model.introspectionStatusDetail);
            this.introspectionResult(model.introspectionResult);
        }

        public final String getIntrospectionId() {
            return this.introspectionId;
        }

        public final void setIntrospectionId(String introspectionId) {
            this.introspectionId = introspectionId;
        }

        @Override
        public final Builder introspectionId(String introspectionId) {
            this.introspectionId = introspectionId;
            return this;
        }

        public final String getIntrospectionStatus() {
            return this.introspectionStatus;
        }

        public final void setIntrospectionStatus(String introspectionStatus) {
            this.introspectionStatus = introspectionStatus;
        }

        @Override
        public final Builder introspectionStatus(String introspectionStatus) {
            this.introspectionStatus = introspectionStatus;
            return this;
        }

        @Override
        public final Builder introspectionStatus(DataSourceIntrospectionStatus introspectionStatus) {
            this.introspectionStatus(introspectionStatus == null ? null : introspectionStatus.toString());
            return this;
        }

        public final String getIntrospectionStatusDetail() {
            return this.introspectionStatusDetail;
        }

        public final void setIntrospectionStatusDetail(String introspectionStatusDetail) {
            this.introspectionStatusDetail = introspectionStatusDetail;
        }

        @Override
        public final Builder introspectionStatusDetail(String introspectionStatusDetail) {
            this.introspectionStatusDetail = introspectionStatusDetail;
            return this;
        }

        public final DataSourceIntrospectionResult.Builder getIntrospectionResult() {
            return this.introspectionResult != null ? this.introspectionResult.toBuilder() : null;
        }

        public final void setIntrospectionResult(DataSourceIntrospectionResult.BuilderImpl introspectionResult) {
            this.introspectionResult = introspectionResult != null ? introspectionResult.build() : null;
        }

        @Override
        public final Builder introspectionResult(DataSourceIntrospectionResult introspectionResult) {
            this.introspectionResult = introspectionResult;
            return this;
        }

        @Override
        public GetDataSourceIntrospectionResponse build() {
            return new GetDataSourceIntrospectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataSourceIntrospectionResponse> {
        public Builder introspectionId(String var1);

        public Builder introspectionStatus(String var1);

        public Builder introspectionStatus(DataSourceIntrospectionStatus var1);

        public Builder introspectionStatusDetail(String var1);

        public Builder introspectionResult(DataSourceIntrospectionResult var1);

        default public Builder introspectionResult(Consumer<DataSourceIntrospectionResult.Builder> introspectionResult) {
            return this.introspectionResult((DataSourceIntrospectionResult)((DataSourceIntrospectionResult.Builder)DataSourceIntrospectionResult.builder().applyMutation(introspectionResult)).build());
        }
    }
}

