/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.ThemeFooterLink;
import software.amazon.awssdk.services.appstream.model.ThemeFooterLinksCopier;
import software.amazon.awssdk.services.appstream.model.ThemeState;
import software.amazon.awssdk.services.appstream.model.ThemeStyling;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Theme
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Theme> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(Theme.getter(Theme::stackName)).setter(Theme.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Theme.getter(Theme::stateAsString)).setter(Theme.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> THEME_TITLE_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThemeTitleText").getter(Theme.getter(Theme::themeTitleText)).setter(Theme.setter(Builder::themeTitleText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeTitleText").build()}).build();
    private static final SdkField<String> THEME_STYLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThemeStyling").getter(Theme.getter(Theme::themeStylingAsString)).setter(Theme.setter(Builder::themeStyling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeStyling").build()}).build();
    private static final SdkField<List<ThemeFooterLink>> THEME_FOOTER_LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ThemeFooterLinks").getter(Theme.getter(Theme::themeFooterLinks)).setter(Theme.setter(Builder::themeFooterLinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeFooterLinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThemeFooterLink::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> THEME_ORGANIZATION_LOGO_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThemeOrganizationLogoURL").getter(Theme.getter(Theme::themeOrganizationLogoURL)).setter(Theme.setter(Builder::themeOrganizationLogoURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeOrganizationLogoURL").build()}).build();
    private static final SdkField<String> THEME_FAVICON_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThemeFaviconURL").getter(Theme.getter(Theme::themeFaviconURL)).setter(Theme.setter(Builder::themeFaviconURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeFaviconURL").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Theme.getter(Theme::createdTime)).setter(Theme.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD, STATE_FIELD, THEME_TITLE_TEXT_FIELD, THEME_STYLING_FIELD, THEME_FOOTER_LINKS_FIELD, THEME_ORGANIZATION_LOGO_URL_FIELD, THEME_FAVICON_URL_FIELD, CREATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StackName", STACK_NAME_FIELD);
            this.put("State", STATE_FIELD);
            this.put("ThemeTitleText", THEME_TITLE_TEXT_FIELD);
            this.put("ThemeStyling", THEME_STYLING_FIELD);
            this.put("ThemeFooterLinks", THEME_FOOTER_LINKS_FIELD);
            this.put("ThemeOrganizationLogoURL", THEME_ORGANIZATION_LOGO_URL_FIELD);
            this.put("ThemeFaviconURL", THEME_FAVICON_URL_FIELD);
            this.put("CreatedTime", CREATED_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String stackName;
    private final String state;
    private final String themeTitleText;
    private final String themeStyling;
    private final List<ThemeFooterLink> themeFooterLinks;
    private final String themeOrganizationLogoURL;
    private final String themeFaviconURL;
    private final Instant createdTime;

    private Theme(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.state = builder.state;
        this.themeTitleText = builder.themeTitleText;
        this.themeStyling = builder.themeStyling;
        this.themeFooterLinks = builder.themeFooterLinks;
        this.themeOrganizationLogoURL = builder.themeOrganizationLogoURL;
        this.themeFaviconURL = builder.themeFaviconURL;
        this.createdTime = builder.createdTime;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final ThemeState state() {
        return ThemeState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String themeTitleText() {
        return this.themeTitleText;
    }

    public final ThemeStyling themeStyling() {
        return ThemeStyling.fromValue(this.themeStyling);
    }

    public final String themeStylingAsString() {
        return this.themeStyling;
    }

    public final boolean hasThemeFooterLinks() {
        return this.themeFooterLinks != null && !(this.themeFooterLinks instanceof SdkAutoConstructList);
    }

    public final List<ThemeFooterLink> themeFooterLinks() {
        return this.themeFooterLinks;
    }

    public final String themeOrganizationLogoURL() {
        return this.themeOrganizationLogoURL;
    }

    public final String themeFaviconURL() {
        return this.themeFaviconURL;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.themeTitleText());
        hashCode = 31 * hashCode + Objects.hashCode(this.themeStylingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThemeFooterLinks() ? this.themeFooterLinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.themeOrganizationLogoURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.themeFaviconURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Theme)) {
            return false;
        }
        Theme other = (Theme)obj;
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.themeTitleText(), other.themeTitleText()) && Objects.equals(this.themeStylingAsString(), other.themeStylingAsString()) && this.hasThemeFooterLinks() == other.hasThemeFooterLinks() && Objects.equals(this.themeFooterLinks(), other.themeFooterLinks()) && Objects.equals(this.themeOrganizationLogoURL(), other.themeOrganizationLogoURL()) && Objects.equals(this.themeFaviconURL(), other.themeFaviconURL()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public final String toString() {
        return ToString.builder((String)"Theme").add("StackName", (Object)this.stackName()).add("State", (Object)this.stateAsString()).add("ThemeTitleText", (Object)this.themeTitleText()).add("ThemeStyling", (Object)this.themeStylingAsString()).add("ThemeFooterLinks", this.hasThemeFooterLinks() ? this.themeFooterLinks() : null).add("ThemeOrganizationLogoURL", (Object)this.themeOrganizationLogoURL()).add("ThemeFaviconURL", (Object)this.themeFaviconURL()).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "ThemeTitleText": {
                return Optional.ofNullable(clazz.cast(this.themeTitleText()));
            }
            case "ThemeStyling": {
                return Optional.ofNullable(clazz.cast(this.themeStylingAsString()));
            }
            case "ThemeFooterLinks": {
                return Optional.ofNullable(clazz.cast(this.themeFooterLinks()));
            }
            case "ThemeOrganizationLogoURL": {
                return Optional.ofNullable(clazz.cast(this.themeOrganizationLogoURL()));
            }
            case "ThemeFaviconURL": {
                return Optional.ofNullable(clazz.cast(this.themeFaviconURL()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Theme, T> g) {
        return obj -> g.apply((Theme)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackName;
        private String state;
        private String themeTitleText;
        private String themeStyling;
        private List<ThemeFooterLink> themeFooterLinks = DefaultSdkAutoConstructList.getInstance();
        private String themeOrganizationLogoURL;
        private String themeFaviconURL;
        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Theme model) {
            this.stackName(model.stackName);
            this.state(model.state);
            this.themeTitleText(model.themeTitleText);
            this.themeStyling(model.themeStyling);
            this.themeFooterLinks(model.themeFooterLinks);
            this.themeOrganizationLogoURL(model.themeOrganizationLogoURL);
            this.themeFaviconURL(model.themeFaviconURL);
            this.createdTime(model.createdTime);
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ThemeState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getThemeTitleText() {
            return this.themeTitleText;
        }

        public final void setThemeTitleText(String themeTitleText) {
            this.themeTitleText = themeTitleText;
        }

        @Override
        public final Builder themeTitleText(String themeTitleText) {
            this.themeTitleText = themeTitleText;
            return this;
        }

        public final String getThemeStyling() {
            return this.themeStyling;
        }

        public final void setThemeStyling(String themeStyling) {
            this.themeStyling = themeStyling;
        }

        @Override
        public final Builder themeStyling(String themeStyling) {
            this.themeStyling = themeStyling;
            return this;
        }

        @Override
        public final Builder themeStyling(ThemeStyling themeStyling) {
            this.themeStyling(themeStyling == null ? null : themeStyling.toString());
            return this;
        }

        public final List<ThemeFooterLink.Builder> getThemeFooterLinks() {
            List<ThemeFooterLink.Builder> result = ThemeFooterLinksCopier.copyToBuilder(this.themeFooterLinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThemeFooterLinks(Collection<ThemeFooterLink.BuilderImpl> themeFooterLinks) {
            this.themeFooterLinks = ThemeFooterLinksCopier.copyFromBuilder(themeFooterLinks);
        }

        @Override
        public final Builder themeFooterLinks(Collection<ThemeFooterLink> themeFooterLinks) {
            this.themeFooterLinks = ThemeFooterLinksCopier.copy(themeFooterLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder themeFooterLinks(ThemeFooterLink ... themeFooterLinks) {
            this.themeFooterLinks(Arrays.asList(themeFooterLinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder themeFooterLinks(Consumer<ThemeFooterLink.Builder> ... themeFooterLinks) {
            this.themeFooterLinks(Stream.of(themeFooterLinks).map(c -> (ThemeFooterLink)((ThemeFooterLink.Builder)ThemeFooterLink.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getThemeOrganizationLogoURL() {
            return this.themeOrganizationLogoURL;
        }

        public final void setThemeOrganizationLogoURL(String themeOrganizationLogoURL) {
            this.themeOrganizationLogoURL = themeOrganizationLogoURL;
        }

        @Override
        public final Builder themeOrganizationLogoURL(String themeOrganizationLogoURL) {
            this.themeOrganizationLogoURL = themeOrganizationLogoURL;
            return this;
        }

        public final String getThemeFaviconURL() {
            return this.themeFaviconURL;
        }

        public final void setThemeFaviconURL(String themeFaviconURL) {
            this.themeFaviconURL = themeFaviconURL;
        }

        @Override
        public final Builder themeFaviconURL(String themeFaviconURL) {
            this.themeFaviconURL = themeFaviconURL;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public Theme build() {
            return new Theme(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Theme> {
        public Builder stackName(String var1);

        public Builder state(String var1);

        public Builder state(ThemeState var1);

        public Builder themeTitleText(String var1);

        public Builder themeStyling(String var1);

        public Builder themeStyling(ThemeStyling var1);

        public Builder themeFooterLinks(Collection<ThemeFooterLink> var1);

        public Builder themeFooterLinks(ThemeFooterLink ... var1);

        public Builder themeFooterLinks(Consumer<ThemeFooterLink.Builder> ... var1);

        public Builder themeOrganizationLogoURL(String var1);

        public Builder themeFaviconURL(String var1);

        public Builder createdTime(Instant var1);
    }
}

