/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FleetErrorCode {
    IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION("IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION"),
    IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION("IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION"),
    IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION("IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION"),
    NETWORK_INTERFACE_LIMIT_EXCEEDED("NETWORK_INTERFACE_LIMIT_EXCEEDED"),
    INTERNAL_SERVICE_ERROR("INTERNAL_SERVICE_ERROR"),
    IAM_SERVICE_ROLE_IS_MISSING("IAM_SERVICE_ROLE_IS_MISSING"),
    MACHINE_ROLE_IS_MISSING("MACHINE_ROLE_IS_MISSING"),
    STS_DISABLED_IN_REGION("STS_DISABLED_IN_REGION"),
    SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES("SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES"),
    IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION("IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION"),
    SUBNET_NOT_FOUND("SUBNET_NOT_FOUND"),
    IMAGE_NOT_FOUND("IMAGE_NOT_FOUND"),
    INVALID_SUBNET_CONFIGURATION("INVALID_SUBNET_CONFIGURATION"),
    SECURITY_GROUPS_NOT_FOUND("SECURITY_GROUPS_NOT_FOUND"),
    IGW_NOT_ATTACHED("IGW_NOT_ATTACHED"),
    IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION("IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION"),
    FLEET_STOPPED("FLEET_STOPPED"),
    FLEET_INSTANCE_PROVISIONING_FAILURE("FLEET_INSTANCE_PROVISIONING_FAILURE"),
    DOMAIN_JOIN_ERROR_FILE_NOT_FOUND("DOMAIN_JOIN_ERROR_FILE_NOT_FOUND"),
    DOMAIN_JOIN_ERROR_ACCESS_DENIED("DOMAIN_JOIN_ERROR_ACCESS_DENIED"),
    DOMAIN_JOIN_ERROR_LOGON_FAILURE("DOMAIN_JOIN_ERROR_LOGON_FAILURE"),
    DOMAIN_JOIN_ERROR_INVALID_PARAMETER("DOMAIN_JOIN_ERROR_INVALID_PARAMETER"),
    DOMAIN_JOIN_ERROR_MORE_DATA("DOMAIN_JOIN_ERROR_MORE_DATA"),
    DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN("DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN"),
    DOMAIN_JOIN_ERROR_NOT_SUPPORTED("DOMAIN_JOIN_ERROR_NOT_SUPPORTED"),
    DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME("DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME"),
    DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED("DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED"),
    DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED("DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED"),
    DOMAIN_JOIN_NERR_PASSWORD_EXPIRED("DOMAIN_JOIN_NERR_PASSWORD_EXPIRED"),
    DOMAIN_JOIN_INTERNAL_SERVICE_ERROR("DOMAIN_JOIN_INTERNAL_SERVICE_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FleetErrorCode> VALUE_MAP;
    private final String value;

    private FleetErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FleetErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FleetErrorCode> knownValues() {
        EnumSet<FleetErrorCode> knownValues = EnumSet.allOf(FleetErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FleetErrorCode.class, FleetErrorCode::toString);
    }
}

