/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsResponse;
import software.amazon.awssdk.services.applicationinsights.model.Problem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProblemResponse
extends ApplicationInsightsResponse
implements ToCopyableBuilder<Builder, DescribeProblemResponse> {
    private static final SdkField<Problem> PROBLEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Problem").getter(DescribeProblemResponse.getter(DescribeProblemResponse::problem)).setter(DescribeProblemResponse.setter(Builder::problem)).constructor(Problem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Problem").build()}).build();
    private static final SdkField<String> SNS_NOTIFICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SNSNotificationArn").getter(DescribeProblemResponse.getter(DescribeProblemResponse::snsNotificationArn)).setter(DescribeProblemResponse.setter(Builder::snsNotificationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNSNotificationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROBLEM_FIELD, SNS_NOTIFICATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Problem", PROBLEM_FIELD);
            this.put("SNSNotificationArn", SNS_NOTIFICATION_ARN_FIELD);
        }
    });
    private final Problem problem;
    private final String snsNotificationArn;

    private DescribeProblemResponse(BuilderImpl builder) {
        super(builder);
        this.problem = builder.problem;
        this.snsNotificationArn = builder.snsNotificationArn;
    }

    public final Problem problem() {
        return this.problem;
    }

    public final String snsNotificationArn() {
        return this.snsNotificationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.problem());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsNotificationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProblemResponse)) {
            return false;
        }
        DescribeProblemResponse other = (DescribeProblemResponse)((Object)obj);
        return Objects.equals(this.problem(), other.problem()) && Objects.equals(this.snsNotificationArn(), other.snsNotificationArn());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProblemResponse").add("Problem", (Object)this.problem()).add("SNSNotificationArn", (Object)this.snsNotificationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Problem": {
                return Optional.ofNullable(clazz.cast(this.problem()));
            }
            case "SNSNotificationArn": {
                return Optional.ofNullable(clazz.cast(this.snsNotificationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProblemResponse, T> g) {
        return obj -> g.apply((DescribeProblemResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsResponse.BuilderImpl
    implements Builder {
        private Problem problem;
        private String snsNotificationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProblemResponse model) {
            super(model);
            this.problem(model.problem);
            this.snsNotificationArn(model.snsNotificationArn);
        }

        public final Problem.Builder getProblem() {
            return this.problem != null ? this.problem.toBuilder() : null;
        }

        public final void setProblem(Problem.BuilderImpl problem) {
            this.problem = problem != null ? problem.build() : null;
        }

        @Override
        public final Builder problem(Problem problem) {
            this.problem = problem;
            return this;
        }

        public final String getSnsNotificationArn() {
            return this.snsNotificationArn;
        }

        public final void setSnsNotificationArn(String snsNotificationArn) {
            this.snsNotificationArn = snsNotificationArn;
        }

        @Override
        public final Builder snsNotificationArn(String snsNotificationArn) {
            this.snsNotificationArn = snsNotificationArn;
            return this;
        }

        @Override
        public DescribeProblemResponse build() {
            return new DescribeProblemResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApplicationInsightsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProblemResponse> {
        public Builder problem(Problem var1);

        default public Builder problem(Consumer<Problem.Builder> problem) {
            return this.problem((Problem)((Problem.Builder)Problem.builder().applyMutation(problem)).build());
        }

        public Builder snsNotificationArn(String var1);
    }
}

