/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appconfig.AppConfigClient;
import software.amazon.awssdk.services.appconfig.internal.UserAgentUtils;
import software.amazon.awssdk.services.appconfig.model.ExtensionSummary;
import software.amazon.awssdk.services.appconfig.model.ListExtensionsRequest;
import software.amazon.awssdk.services.appconfig.model.ListExtensionsResponse;

public class ListExtensionsIterable
implements SdkIterable<ListExtensionsResponse> {
    private final AppConfigClient client;
    private final ListExtensionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExtensionsIterable(AppConfigClient client, ListExtensionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListExtensionsResponseFetcher();
    }

    public Iterator<ListExtensionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExtensionSummary> items() {
        Function<ListExtensionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListExtensionsResponseFetcher
    implements SyncPageFetcher<ListExtensionsResponse> {
        private ListExtensionsResponseFetcher() {
        }

        public boolean hasNextPage(ListExtensionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExtensionsResponse nextPage(ListExtensionsResponse previousPage) {
            if (previousPage == null) {
                return ListExtensionsIterable.this.client.listExtensions(ListExtensionsIterable.this.firstRequest);
            }
            return ListExtensionsIterable.this.client.listExtensions((ListExtensionsRequest)((Object)ListExtensionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

