/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.AccessLogSettings;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.services.apigatewayv2.model.RouteSettings;
import software.amazon.awssdk.services.apigatewayv2.model.RouteSettingsMapCopier;
import software.amazon.awssdk.services.apigatewayv2.model.StageVariablesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStageRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, UpdateStageRequest> {
    private static final SdkField<AccessLogSettings> ACCESS_LOG_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessLogSettings").getter(UpdateStageRequest.getter(UpdateStageRequest::accessLogSettings)).setter(UpdateStageRequest.setter(Builder::accessLogSettings)).constructor(AccessLogSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessLogSettings").build()}).build();
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiId").getter(UpdateStageRequest.getter(UpdateStageRequest::apiId)).setter(UpdateStageRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<Boolean> AUTO_DEPLOY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoDeploy").getter(UpdateStageRequest.getter(UpdateStageRequest::autoDeploy)).setter(UpdateStageRequest.setter(Builder::autoDeploy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoDeploy").build()}).build();
    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientCertificateId").getter(UpdateStageRequest.getter(UpdateStageRequest::clientCertificateId)).setter(UpdateStageRequest.setter(Builder::clientCertificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateId").build()}).build();
    private static final SdkField<RouteSettings> DEFAULT_ROUTE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultRouteSettings").getter(UpdateStageRequest.getter(UpdateStageRequest::defaultRouteSettings)).setter(UpdateStageRequest.setter(Builder::defaultRouteSettings)).constructor(RouteSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultRouteSettings").build()}).build();
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentId").getter(UpdateStageRequest.getter(UpdateStageRequest::deploymentId)).setter(UpdateStageRequest.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateStageRequest.getter(UpdateStageRequest::description)).setter(UpdateStageRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, RouteSettings>> ROUTE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RouteSettings").getter(UpdateStageRequest.getter(UpdateStageRequest::routeSettings)).setter(UpdateStageRequest.setter(Builder::routeSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeSettings").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StageName").getter(UpdateStageRequest.getter(UpdateStageRequest::stageName)).setter(UpdateStageRequest.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("stageName").build()}).build();
    private static final SdkField<Map<String, String>> STAGE_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("StageVariables").getter(UpdateStageRequest.getter(UpdateStageRequest::stageVariables)).setter(UpdateStageRequest.setter(Builder::stageVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_LOG_SETTINGS_FIELD, API_ID_FIELD, AUTO_DEPLOY_FIELD, CLIENT_CERTIFICATE_ID_FIELD, DEFAULT_ROUTE_SETTINGS_FIELD, DEPLOYMENT_ID_FIELD, DESCRIPTION_FIELD, ROUTE_SETTINGS_FIELD, STAGE_NAME_FIELD, STAGE_VARIABLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accessLogSettings", ACCESS_LOG_SETTINGS_FIELD);
            this.put("apiId", API_ID_FIELD);
            this.put("autoDeploy", AUTO_DEPLOY_FIELD);
            this.put("clientCertificateId", CLIENT_CERTIFICATE_ID_FIELD);
            this.put("defaultRouteSettings", DEFAULT_ROUTE_SETTINGS_FIELD);
            this.put("deploymentId", DEPLOYMENT_ID_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("routeSettings", ROUTE_SETTINGS_FIELD);
            this.put("stageName", STAGE_NAME_FIELD);
            this.put("stageVariables", STAGE_VARIABLES_FIELD);
        }
    });
    private final AccessLogSettings accessLogSettings;
    private final String apiId;
    private final Boolean autoDeploy;
    private final String clientCertificateId;
    private final RouteSettings defaultRouteSettings;
    private final String deploymentId;
    private final String description;
    private final Map<String, RouteSettings> routeSettings;
    private final String stageName;
    private final Map<String, String> stageVariables;

    private UpdateStageRequest(BuilderImpl builder) {
        super(builder);
        this.accessLogSettings = builder.accessLogSettings;
        this.apiId = builder.apiId;
        this.autoDeploy = builder.autoDeploy;
        this.clientCertificateId = builder.clientCertificateId;
        this.defaultRouteSettings = builder.defaultRouteSettings;
        this.deploymentId = builder.deploymentId;
        this.description = builder.description;
        this.routeSettings = builder.routeSettings;
        this.stageName = builder.stageName;
        this.stageVariables = builder.stageVariables;
    }

    public final AccessLogSettings accessLogSettings() {
        return this.accessLogSettings;
    }

    public final String apiId() {
        return this.apiId;
    }

    public final Boolean autoDeploy() {
        return this.autoDeploy;
    }

    public final String clientCertificateId() {
        return this.clientCertificateId;
    }

    public final RouteSettings defaultRouteSettings() {
        return this.defaultRouteSettings;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRouteSettings() {
        return this.routeSettings != null && !(this.routeSettings instanceof SdkAutoConstructMap);
    }

    public final Map<String, RouteSettings> routeSettings() {
        return this.routeSettings;
    }

    public final String stageName() {
        return this.stageName;
    }

    public final boolean hasStageVariables() {
        return this.stageVariables != null && !(this.stageVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> stageVariables() {
        return this.stageVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLogSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoDeploy());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRouteSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteSettings() ? this.routeSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStageVariables() ? this.stageVariables() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStageRequest)) {
            return false;
        }
        UpdateStageRequest other = (UpdateStageRequest)((Object)obj);
        return Objects.equals(this.accessLogSettings(), other.accessLogSettings()) && Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.autoDeploy(), other.autoDeploy()) && Objects.equals(this.clientCertificateId(), other.clientCertificateId()) && Objects.equals(this.defaultRouteSettings(), other.defaultRouteSettings()) && Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.description(), other.description()) && this.hasRouteSettings() == other.hasRouteSettings() && Objects.equals(this.routeSettings(), other.routeSettings()) && Objects.equals(this.stageName(), other.stageName()) && this.hasStageVariables() == other.hasStageVariables() && Objects.equals(this.stageVariables(), other.stageVariables());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStageRequest").add("AccessLogSettings", (Object)this.accessLogSettings()).add("ApiId", (Object)this.apiId()).add("AutoDeploy", (Object)this.autoDeploy()).add("ClientCertificateId", (Object)this.clientCertificateId()).add("DefaultRouteSettings", (Object)this.defaultRouteSettings()).add("DeploymentId", (Object)this.deploymentId()).add("Description", (Object)this.description()).add("RouteSettings", this.hasRouteSettings() ? this.routeSettings() : null).add("StageName", (Object)this.stageName()).add("StageVariables", this.hasStageVariables() ? this.stageVariables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessLogSettings": {
                return Optional.ofNullable(clazz.cast(this.accessLogSettings()));
            }
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "AutoDeploy": {
                return Optional.ofNullable(clazz.cast(this.autoDeploy()));
            }
            case "ClientCertificateId": {
                return Optional.ofNullable(clazz.cast(this.clientCertificateId()));
            }
            case "DefaultRouteSettings": {
                return Optional.ofNullable(clazz.cast(this.defaultRouteSettings()));
            }
            case "DeploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RouteSettings": {
                return Optional.ofNullable(clazz.cast(this.routeSettings()));
            }
            case "StageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "StageVariables": {
                return Optional.ofNullable(clazz.cast(this.stageVariables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStageRequest, T> g) {
        return obj -> g.apply((UpdateStageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private AccessLogSettings accessLogSettings;
        private String apiId;
        private Boolean autoDeploy;
        private String clientCertificateId;
        private RouteSettings defaultRouteSettings;
        private String deploymentId;
        private String description;
        private Map<String, RouteSettings> routeSettings = DefaultSdkAutoConstructMap.getInstance();
        private String stageName;
        private Map<String, String> stageVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStageRequest model) {
            super(model);
            this.accessLogSettings(model.accessLogSettings);
            this.apiId(model.apiId);
            this.autoDeploy(model.autoDeploy);
            this.clientCertificateId(model.clientCertificateId);
            this.defaultRouteSettings(model.defaultRouteSettings);
            this.deploymentId(model.deploymentId);
            this.description(model.description);
            this.routeSettings(model.routeSettings);
            this.stageName(model.stageName);
            this.stageVariables(model.stageVariables);
        }

        public final AccessLogSettings.Builder getAccessLogSettings() {
            return this.accessLogSettings != null ? this.accessLogSettings.toBuilder() : null;
        }

        public final void setAccessLogSettings(AccessLogSettings.BuilderImpl accessLogSettings) {
            this.accessLogSettings = accessLogSettings != null ? accessLogSettings.build() : null;
        }

        @Override
        public final Builder accessLogSettings(AccessLogSettings accessLogSettings) {
            this.accessLogSettings = accessLogSettings;
            return this;
        }

        public final String getApiId() {
            return this.apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final Boolean getAutoDeploy() {
            return this.autoDeploy;
        }

        public final void setAutoDeploy(Boolean autoDeploy) {
            this.autoDeploy = autoDeploy;
        }

        @Override
        public final Builder autoDeploy(Boolean autoDeploy) {
            this.autoDeploy = autoDeploy;
            return this;
        }

        public final String getClientCertificateId() {
            return this.clientCertificateId;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final RouteSettings.Builder getDefaultRouteSettings() {
            return this.defaultRouteSettings != null ? this.defaultRouteSettings.toBuilder() : null;
        }

        public final void setDefaultRouteSettings(RouteSettings.BuilderImpl defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings != null ? defaultRouteSettings.build() : null;
        }

        @Override
        public final Builder defaultRouteSettings(RouteSettings defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings;
            return this;
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, RouteSettings.Builder> getRouteSettings() {
            Map<String, RouteSettings.Builder> result = RouteSettingsMapCopier.copyToBuilder(this.routeSettings);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRouteSettings(Map<String, RouteSettings.BuilderImpl> routeSettings) {
            this.routeSettings = RouteSettingsMapCopier.copyFromBuilder(routeSettings);
        }

        @Override
        public final Builder routeSettings(Map<String, RouteSettings> routeSettings) {
            this.routeSettings = RouteSettingsMapCopier.copy(routeSettings);
            return this;
        }

        public final String getStageName() {
            return this.stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final Map<String, String> getStageVariables() {
            if (this.stageVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.stageVariables;
        }

        public final void setStageVariables(Map<String, String> stageVariables) {
            this.stageVariables = StageVariablesMapCopier.copy(stageVariables);
        }

        @Override
        public final Builder stageVariables(Map<String, String> stageVariables) {
            this.stageVariables = StageVariablesMapCopier.copy(stageVariables);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStageRequest build() {
            return new UpdateStageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStageRequest> {
        public Builder accessLogSettings(AccessLogSettings var1);

        default public Builder accessLogSettings(Consumer<AccessLogSettings.Builder> accessLogSettings) {
            return this.accessLogSettings((AccessLogSettings)((AccessLogSettings.Builder)AccessLogSettings.builder().applyMutation(accessLogSettings)).build());
        }

        public Builder apiId(String var1);

        public Builder autoDeploy(Boolean var1);

        public Builder clientCertificateId(String var1);

        public Builder defaultRouteSettings(RouteSettings var1);

        default public Builder defaultRouteSettings(Consumer<RouteSettings.Builder> defaultRouteSettings) {
            return this.defaultRouteSettings((RouteSettings)((RouteSettings.Builder)RouteSettings.builder().applyMutation(defaultRouteSettings)).build());
        }

        public Builder deploymentId(String var1);

        public Builder description(String var1);

        public Builder routeSettings(Map<String, RouteSettings> var1);

        public Builder stageName(String var1);

        public Builder stageVariables(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

