/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.ValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Criterion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Criterion> {
    private static final SdkField<List<String>> EQ_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eq").getter(Criterion.getter(Criterion::eq)).setter(Criterion.setter(Builder::eq)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eq").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NEQ_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("neq").getter(Criterion.getter(Criterion::neq)).setter(Criterion.setter(Builder::neq)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neq").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("contains").getter(Criterion.getter(Criterion::contains)).setter(Criterion.setter(Builder::contains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> EXISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("exists").getter(Criterion.getter(Criterion::exists)).setter(Criterion.setter(Builder::exists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exists").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQ_FIELD, NEQ_FIELD, CONTAINS_FIELD, EXISTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("eq", EQ_FIELD);
            this.put("neq", NEQ_FIELD);
            this.put("contains", CONTAINS_FIELD);
            this.put("exists", EXISTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> eq;
    private final List<String> neq;
    private final List<String> contains;
    private final Boolean exists;

    private Criterion(BuilderImpl builder) {
        this.eq = builder.eq;
        this.neq = builder.neq;
        this.contains = builder.contains;
        this.exists = builder.exists;
    }

    public final boolean hasEq() {
        return this.eq != null && !(this.eq instanceof SdkAutoConstructList);
    }

    public final List<String> eq() {
        return this.eq;
    }

    public final boolean hasNeq() {
        return this.neq != null && !(this.neq instanceof SdkAutoConstructList);
    }

    public final List<String> neq() {
        return this.neq;
    }

    public final boolean hasContains() {
        return this.contains != null && !(this.contains instanceof SdkAutoConstructList);
    }

    public final List<String> contains() {
        return this.contains;
    }

    public final Boolean exists() {
        return this.exists;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEq() ? this.eq() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNeq() ? this.neq() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContains() ? this.contains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.exists());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Criterion)) {
            return false;
        }
        Criterion other = (Criterion)obj;
        return this.hasEq() == other.hasEq() && Objects.equals(this.eq(), other.eq()) && this.hasNeq() == other.hasNeq() && Objects.equals(this.neq(), other.neq()) && this.hasContains() == other.hasContains() && Objects.equals(this.contains(), other.contains()) && Objects.equals(this.exists(), other.exists());
    }

    public final String toString() {
        return ToString.builder((String)"Criterion").add("Eq", this.hasEq() ? this.eq() : null).add("Neq", this.hasNeq() ? this.neq() : null).add("Contains", this.hasContains() ? this.contains() : null).add("Exists", (Object)this.exists()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eq": {
                return Optional.ofNullable(clazz.cast(this.eq()));
            }
            case "neq": {
                return Optional.ofNullable(clazz.cast(this.neq()));
            }
            case "contains": {
                return Optional.ofNullable(clazz.cast(this.contains()));
            }
            case "exists": {
                return Optional.ofNullable(clazz.cast(this.exists()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Criterion, T> g) {
        return obj -> g.apply((Criterion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> eq = DefaultSdkAutoConstructList.getInstance();
        private List<String> neq = DefaultSdkAutoConstructList.getInstance();
        private List<String> contains = DefaultSdkAutoConstructList.getInstance();
        private Boolean exists;

        private BuilderImpl() {
        }

        private BuilderImpl(Criterion model) {
            this.eq(model.eq);
            this.neq(model.neq);
            this.contains(model.contains);
            this.exists(model.exists);
        }

        public final Collection<String> getEq() {
            if (this.eq instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eq;
        }

        public final void setEq(Collection<String> eq) {
            this.eq = ValueListCopier.copy(eq);
        }

        @Override
        public final Builder eq(Collection<String> eq) {
            this.eq = ValueListCopier.copy(eq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eq(String ... eq) {
            this.eq(Arrays.asList(eq));
            return this;
        }

        public final Collection<String> getNeq() {
            if (this.neq instanceof SdkAutoConstructList) {
                return null;
            }
            return this.neq;
        }

        public final void setNeq(Collection<String> neq) {
            this.neq = ValueListCopier.copy(neq);
        }

        @Override
        public final Builder neq(Collection<String> neq) {
            this.neq = ValueListCopier.copy(neq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neq(String ... neq) {
            this.neq(Arrays.asList(neq));
            return this;
        }

        public final Collection<String> getContains() {
            if (this.contains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contains;
        }

        public final void setContains(Collection<String> contains) {
            this.contains = ValueListCopier.copy(contains);
        }

        @Override
        public final Builder contains(Collection<String> contains) {
            this.contains = ValueListCopier.copy(contains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contains(String ... contains) {
            this.contains(Arrays.asList(contains));
            return this;
        }

        public final Boolean getExists() {
            return this.exists;
        }

        public final void setExists(Boolean exists) {
            this.exists = exists;
        }

        @Override
        public final Builder exists(Boolean exists) {
            this.exists = exists;
            return this;
        }

        public Criterion build() {
            return new Criterion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Criterion> {
        public Builder eq(Collection<String> var1);

        public Builder eq(String ... var1);

        public Builder neq(Collection<String> var1);

        public Builder neq(String ... var1);

        public Builder contains(Collection<String> var1);

        public Builder contains(String ... var1);

        public Builder exists(Boolean var1);
    }
}

