/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.TrailProperties;
import software.amazon.awssdk.services.accessanalyzer.model.TrailPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudTrailProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudTrailProperties> {
    private static final SdkField<List<TrailProperties>> TRAIL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("trailProperties").getter(CloudTrailProperties.getter(CloudTrailProperties::trailProperties)).setter(CloudTrailProperties.setter(Builder::trailProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trailProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrailProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(CloudTrailProperties.getter(CloudTrailProperties::startTime)).setter(CloudTrailProperties.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(CloudTrailProperties.getter(CloudTrailProperties::endTime)).setter(CloudTrailProperties.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_PROPERTIES_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("trailProperties", TRAIL_PROPERTIES_FIELD);
            this.put("startTime", START_TIME_FIELD);
            this.put("endTime", END_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<TrailProperties> trailProperties;
    private final Instant startTime;
    private final Instant endTime;

    private CloudTrailProperties(BuilderImpl builder) {
        this.trailProperties = builder.trailProperties;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final boolean hasTrailProperties() {
        return this.trailProperties != null && !(this.trailProperties instanceof SdkAutoConstructList);
    }

    public final List<TrailProperties> trailProperties() {
        return this.trailProperties;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrailProperties() ? this.trailProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudTrailProperties)) {
            return false;
        }
        CloudTrailProperties other = (CloudTrailProperties)obj;
        return this.hasTrailProperties() == other.hasTrailProperties() && Objects.equals(this.trailProperties(), other.trailProperties()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"CloudTrailProperties").add("TrailProperties", this.hasTrailProperties() ? this.trailProperties() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "trailProperties": {
                return Optional.ofNullable(clazz.cast(this.trailProperties()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CloudTrailProperties, T> g) {
        return obj -> g.apply((CloudTrailProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TrailProperties> trailProperties = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudTrailProperties model) {
            this.trailProperties(model.trailProperties);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final List<TrailProperties.Builder> getTrailProperties() {
            List<TrailProperties.Builder> result = TrailPropertiesListCopier.copyToBuilder(this.trailProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrailProperties(Collection<TrailProperties.BuilderImpl> trailProperties) {
            this.trailProperties = TrailPropertiesListCopier.copyFromBuilder(trailProperties);
        }

        @Override
        public final Builder trailProperties(Collection<TrailProperties> trailProperties) {
            this.trailProperties = TrailPropertiesListCopier.copy(trailProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trailProperties(TrailProperties ... trailProperties) {
            this.trailProperties(Arrays.asList(trailProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trailProperties(Consumer<TrailProperties.Builder> ... trailProperties) {
            this.trailProperties(Stream.of(trailProperties).map(c -> (TrailProperties)((TrailProperties.Builder)TrailProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public CloudTrailProperties build() {
            return new CloudTrailProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudTrailProperties> {
        public Builder trailProperties(Collection<TrailProperties> var1);

        public Builder trailProperties(TrailProperties ... var1);

        public Builder trailProperties(Consumer<TrailProperties.Builder> ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

