/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.xel.fn;

import org.zkoss.lang.Objects;
import org.zkoss.util.Locales;
import org.zkoss.util.logging.Log;

public class StringFns {
    private static Log log = Log.lookup(StringFns.class);

    public static String cat(String s1, String s2) {
        if (s1 == null) {
            return s2 != null ? s2 : "";
        }
        return s2 != null ? s1 + s2 : s1;
    }

    public static String cat3(String s1, String s2, String s3) {
        return StringFns.cat(StringFns.cat(s1, s2), s3);
    }

    public static String cat4(String s1, String s2, String s3, String s4) {
        return StringFns.cat(StringFns.cat(StringFns.cat(s1, s2), s3), s4);
    }

    public static String cat5(String s1, String s2, String s3, String s4, String s5) {
        return StringFns.cat(StringFns.cat(StringFns.cat(StringFns.cat(s1, s2), s3), s4), s5);
    }

    public static String toLowerCase(String s) {
        return s != null ? s.toLowerCase(Locales.getCurrent()) : null;
    }

    public static String toUpperCase(String s) {
        return s != null ? s.toUpperCase(Locales.getCurrent()) : null;
    }

    public static String trim(String s) {
        return s != null ? s.trim() : null;
    }

    public static String[] split(String s, String separator) {
        return s != null ? s.split(separator) : null;
    }

    public static String join(Object[] ss, String separator) {
        if (ss == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < ss.length; ++j) {
            if (j != 0) {
                sb.append(separator);
            }
            sb.append(ss[j]);
        }
        return ss.toString();
    }

    public static boolean startsWith(String s1, String s2) {
        return s1 != null && s2 != null && s1.startsWith(s2);
    }

    public static boolean endsWith(String s1, String s2) {
        return s1 != null && s2 != null && s1.endsWith(s2);
    }

    public static String substring(String s, int from, int to) {
        return s != null ? s.substring(from, to) : null;
    }

    public static String replace(String src, String from, String to) {
        if (Objects.equals(from, to)) {
            return src;
        }
        StringBuffer sb = new StringBuffer(src);
        if ("\n".equals(from) || "\r\n".equals(from)) {
            StringFns.replace0(sb, "\r\n", to);
            StringFns.replace0(sb, "\n", to);
        } else {
            StringFns.replace0(sb, from, to);
        }
        return sb.toString();
    }

    private static void replace0(StringBuffer sb, String from, String to) {
        int len = from.length();
        int j = 0;
        while ((j = sb.indexOf(from, j)) >= 0) {
            sb.replace(j, j + len, to);
            j += to.length();
        }
    }

    public static String eatQuot(String s) {
        int len = s != null ? s.length() : 0;
        StringBuffer sb = null;
        for (int j = 0; j < len; ++j) {
            char cc = s.charAt(j);
            if (cc == '\'' || cc == '\"') {
                if (sb != null) continue;
                log.warning("JavaScript Injection? Unexpected string detected: " + s);
                sb = new StringBuffer(len);
                if (j <= 0) continue;
                sb.append(s.substring(0, j));
                continue;
            }
            if (sb == null) continue;
            sb.append(cc);
        }
        return sb != null ? sb.toString() : s;
    }
}

