/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.zkoss.lang.JVMs;
import org.zkoss.lang.Objects;
import org.zkoss.math.BigIntegers;
import org.zkoss.util.Locales;

public class BigDecimals {
    public static final BigDecimal ZERO = Objects.ZERO_BIG_DECIMAL;
    public static final BigDecimal ONE = new BigDecimal(BigInteger.ONE);
    public static final BigDecimal MINUS_ONE = new BigDecimal(BigInteger.ONE.negate());
    public static final int NUMBER_PRECISION = 38;
    public static final int NUMBER_SCALE = 6;
    public static final int FINE_NUMBER_PRECISION = 20;
    public static final int FINE_NUMBER_SCALE = 8;

    public static final BigDecimal toBigDecimal(double v, int scale, int roundingMode) {
        return new BigDecimal(v).setScale(scale, roundingMode);
    }

    public static final BigDecimal toBigDecimal(double v, int scale) {
        return BigDecimals.toBigDecimal(v, scale, 4);
    }

    public static final BigDecimal toBigDecimal(int v, int scale) {
        return new BigDecimal(BigIntegers.toBigInteger(v), scale);
    }

    public static final BigDecimal toBigDecimal(long v, int scale) {
        return new BigDecimal(BigIntegers.toBigInteger(v), scale);
    }

    public static final BigDecimal toBigDecimal(int v) {
        return v == 0 ? ZERO : new BigDecimal(BigIntegers.toBigInteger(v));
    }

    public static final BigDecimal toBigDecimal(long v) {
        return v == 0L ? ZERO : new BigDecimal(BigIntegers.toBigInteger(v));
    }

    public static final BigDecimal toBigDecimal(short v) {
        return v == 0 ? ZERO : new BigDecimal(BigIntegers.toBigInteger(v));
    }

    public static final BigDecimal toBigDecimal(byte v) {
        return v == 0 ? ZERO : new BigDecimal(BigIntegers.toBigInteger(v));
    }

    public static final BigDecimal toBigDecimal(Integer v) {
        return BigDecimals.toBigDecimal((int)v);
    }

    public static final BigDecimal toBigDecimal(Long v) {
        return BigDecimals.toBigDecimal((long)v);
    }

    public static final BigDecimal toBigDecimal(Short v) {
        return BigDecimals.toBigDecimal((short)v);
    }

    public static final BigDecimal toBigDecimal(Byte v) {
        return BigDecimals.toBigDecimal((byte)v);
    }

    public static final String toPlainString(BigDecimal bd) {
        if (JVMs.isJava5()) {
            return bd.toPlainString();
        }
        int scale = bd.scale();
        if (scale <= 0) {
            if (scale < 0) {
                bd = bd.setScale(0);
            }
            return bd.unscaledValue().toString();
        }
        int signum = bd.signum();
        String intString = bd.unscaledValue().abs().toString();
        int insertionPoint = intString.length() - scale;
        if (insertionPoint == 0) {
            return (signum < 0 ? "-0." : "0.") + intString;
        }
        StringBuffer sb = new StringBuffer(32);
        if (insertionPoint > 0) {
            sb.append(intString).insert(insertionPoint, '.');
            if (signum < 0) {
                sb.insert(0, '-');
            }
        } else {
            sb.append(signum < 0 ? "-0." : "0.");
            for (int i = 0; i < -insertionPoint; ++i) {
                sb.append('0');
            }
            sb.append(intString);
        }
        return sb.toString();
    }

    public static final String toLocaleString(BigDecimal bd, Locale locale) {
        if (locale == null) {
            locale = Locales.getCurrent();
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        char DECIMAL = symbols.getDecimalSeparator();
        char MINUS = symbols.getMinusSign();
        return BigDecimals.toPlainString(bd).replace('.', DECIMAL).replace('-', MINUS);
    }
}

