/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem.deployment;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponent;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.component.pool.PooledComponent;
import org.jboss.as.ejb3.component.singleton.SingletonComponent;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateless.StatelessComponentDescription;
import org.jboss.as.ejb3.component.stateless.StatelessSessionComponent;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.pool.Pool;
import org.jboss.as.ejb3.subsystem.deployment.AbstractEJBComponentRuntimeHandler;
import org.jboss.as.ejb3.subsystem.deployment.MessageDrivenBeanRuntimeHandler;
import org.jboss.as.ejb3.subsystem.deployment.SingletonBeanRuntimeHandler;
import org.jboss.as.ejb3.subsystem.deployment.StatefulSessionBeanRuntimeHandler;
import org.jboss.as.ejb3.subsystem.deployment.StatelessSessionBeanRuntimeHandler;

public enum EJBComponentType {
    MESSAGE_DRIVEN("message-driven-bean", MessageDrivenComponent.class, MessageDrivenComponentDescription.class),
    SINGLETON("singleton-bean", SingletonComponent.class, SingletonComponentDescription.class),
    STATELESS("stateless-session-bean", StatelessSessionComponent.class, StatelessComponentDescription.class),
    STATEFUL("stateful-session-bean", StatefulSessionComponent.class, StatefulComponentDescription.class);

    private static final Map<Class<?>, EJBComponentType> typeByDescriptionClass;
    private final String resourceType;
    private final Class<? extends EJBComponent> componentClass;
    private final Class<? extends EJBComponentDescription> componentDescriptionClass;

    private EJBComponentType(String resourceType, Class<? extends EJBComponent> componentClass, Class<? extends EJBComponentDescription> componentDescriptionClass) {
        this.resourceType = resourceType;
        this.componentClass = componentClass;
        this.componentDescriptionClass = componentDescriptionClass;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public Class<? extends EJBComponent> getComponentClass() {
        return this.componentClass;
    }

    public Class<? extends EJBComponentDescription> getComponentDescriptionClass() {
        return this.componentDescriptionClass;
    }

    public boolean hasPool() {
        switch (this) {
            case STATEFUL: 
            case SINGLETON: {
                return false;
            }
        }
        return true;
    }

    public boolean hasTimer() {
        switch (this) {
            case SINGLETON: 
            case STATELESS: 
            case MESSAGE_DRIVEN: {
                return true;
            }
        }
        return false;
    }

    public Pool<?> getPool(EJBComponent component) {
        return this.pooledComponent(component).getPool();
    }

    public AbstractEJBComponentRuntimeHandler<?> getRuntimeHandler() {
        switch (this) {
            case MESSAGE_DRIVEN: {
                return MessageDrivenBeanRuntimeHandler.INSTANCE;
            }
            case SINGLETON: {
                return SingletonBeanRuntimeHandler.INSTANCE;
            }
            case STATELESS: {
                return StatelessSessionBeanRuntimeHandler.INSTANCE;
            }
            case STATEFUL: {
                return StatefulSessionBeanRuntimeHandler.INSTANCE;
            }
        }
        throw EjbLogger.ROOT_LOGGER.unknownComponentType(this);
    }

    public static EJBComponentType getComponentType(ComponentConfiguration componentConfiguration) {
        ComponentDescription description = componentConfiguration.getComponentDescription();
        EJBComponentType type = typeByDescriptionClass.get(description.getClass());
        if (type != null) {
            return type;
        }
        for (Map.Entry<Class<?>, EJBComponentType> entry : typeByDescriptionClass.entrySet()) {
            if (!entry.getKey().isAssignableFrom(description.getClass())) continue;
            return entry.getValue();
        }
        throw EjbLogger.ROOT_LOGGER.unknownComponentDescriptionType(description.getClass());
    }

    protected PooledComponent<?> pooledComponent(EJBComponent component) {
        switch (this) {
            case MESSAGE_DRIVEN: {
                return (PooledComponent)MessageDrivenComponent.class.cast((Object)component);
            }
            case STATELESS: {
                return (PooledComponent)StatelessSessionComponent.class.cast((Object)component);
            }
            case STATEFUL: 
            case SINGLETON: {
                throw EjbLogger.ROOT_LOGGER.invalidComponentType(this.getComponentClass().getSimpleName());
            }
        }
        throw EjbLogger.ROOT_LOGGER.unknownComponentType(this);
    }

    static {
        typeByDescriptionClass = new HashMap();
        for (EJBComponentType type : EJBComponentType.values()) {
            typeByDescriptionClass.put(type.componentDescriptionClass, type);
        }
    }
}

