/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.io.IOException;
import java.lang.reflect.Proxy;
import org.jboss.marshalling.cloner.ClassCloner;

public class LocalInvocationClassCloner
implements ClassCloner {
    private final ClassLoader destClassLoader;

    public LocalInvocationClassCloner(ClassLoader destClassLoader) {
        this.destClassLoader = destClassLoader;
    }

    public Class<?> clone(Class<?> original) throws IOException, ClassNotFoundException {
        String name = original.getName();
        if (name.startsWith("java.")) {
            return original;
        }
        if (original.getClassLoader() == this.destClassLoader) {
            return original;
        }
        try {
            return Class.forName(name, true, this.destClassLoader);
        }
        catch (ClassNotFoundException e) {
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            if (current != this.destClassLoader) {
                try {
                    return Class.forName(name, true, current);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return original;
        }
    }

    public Class<?> cloneProxy(Class<?> proxyClass) throws IOException, ClassNotFoundException {
        Class<?>[] origInterfaces = proxyClass.getInterfaces();
        Class[] interfaces = new Class[origInterfaces.length];
        int origInterfacesLength = origInterfaces.length;
        for (int i = 0; i < origInterfacesLength; ++i) {
            interfaces[i] = this.clone(origInterfaces[i]);
        }
        return Proxy.getProxyClass(this.destClassLoader, interfaces);
    }
}

