/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.enterprise.concurrent.ContextService;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ee.concurrent.handle.ContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.ResetContextHandle;
import org.jboss.as.ee.concurrent.handle.SetupContextHandle;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.invocation.InterceptorContext;

public class EJBContextHandleFactory
implements ContextHandleFactory {
    public static final String NAME = "EJB";
    public static final EJBContextHandleFactory INSTANCE = new EJBContextHandleFactory();

    private EJBContextHandleFactory() {
    }

    public SetupContextHandle saveContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        return new EJBContextHandle();
    }

    public String getName() {
        return NAME;
    }

    public int getChainPriority() {
        return 500;
    }

    public void writeSetupContextHandle(SetupContextHandle contextHandle, ObjectOutputStream out) throws IOException {
        out.writeObject(contextHandle);
    }

    public SetupContextHandle readSetupContextHandle(ObjectInputStream in) throws IOException, ClassNotFoundException {
        return (SetupContextHandle)in.readObject();
    }

    private static class EJBContextHandle
    implements SetupContextHandle,
    ResetContextHandle {
        private static final long serialVersionUID = 9158258921823908698L;
        private final transient InterceptorContext interceptorContext;

        private EJBContextHandle() {
            InterceptorContext interceptorContext = CurrentInvocationContext.get();
            if (interceptorContext != null) {
                this.interceptorContext = interceptorContext.clone();
                this.interceptorContext.putPrivateData(InvocationType.class, (Object)InvocationType.CONCURRENT_CONTEXT);
            } else {
                this.interceptorContext = null;
            }
        }

        public String getFactoryName() {
            return EJBContextHandleFactory.NAME;
        }

        public ResetContextHandle setup() throws IllegalStateException {
            if (this.interceptorContext != null) {
                CurrentInvocationContext.push(this.interceptorContext);
            }
            return this;
        }

        public void reset() {
            if (this.interceptorContext != null) {
                CurrentInvocationContext.pop();
            }
        }
    }
}

