/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.runtime;

import java.net.BindException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Vetoed;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.swarm.arquillian.daemon.server.Server;
import org.wildfly.swarm.arquillian.daemon.server.ServerLifecycleException;

@Vetoed
public class DaemonService
implements Service<Server> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"wildfly", "swarm", "arquillian", "daemon"});
    private static final Logger log = Logger.getLogger(DaemonService.class.getName());
    private Server server;

    public void start(StartContext context) throws StartException {
        int port = Integer.getInteger("swarm.arquillian.daemon.port", 12345);
        try {
            this.server = Server.create((String)"localhost", (int)port);
            this.server.start();
        }
        catch (Exception e) {
            if (e instanceof BindException) {
                log.log(Level.SEVERE, "Couldn't bind Arquillian Daemon on localhost:" + port + "; you can change the port using system property '" + "swarm.arquillian.daemon.port" + "'", e);
            }
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        try {
            this.server.stop();
        }
        catch (ServerLifecycleException e) {
            throw new RuntimeException(e);
        }
    }

    public Server getValue() throws IllegalStateException, IllegalArgumentException {
        return this.server;
    }

    static void addService(ServiceTarget serviceTarget) {
        DaemonService daemon = new DaemonService();
        serviceTarget.addService(SERVICE_NAME, (Service)daemon).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

