/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.temporal.TemporalAccessor;
import org.apache.commons.lang3.Validate;
import org.threeten.extra.chrono.JulianDate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.ItemIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.ValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize
public class TimeValueImpl
extends ValueImpl
implements TimeValue {
    private final JacksonInnerTime value;

    public TimeValueImpl(long year, byte month, byte day, byte hour, byte minute, byte second, byte precision, int beforeTolerance, int afterTolerance, int timezoneOffset, String calendarModel) {
        super("time");
        this.value = new JacksonInnerTime(year, month, day, hour, minute, second, timezoneOffset, beforeTolerance, afterTolerance, precision, calendarModel);
    }

    @JsonCreator
    TimeValueImpl(@JsonProperty(value="value") JacksonInnerTime value) {
        super("time");
        this.value = value;
    }

    public JacksonInnerTime getValue() {
        return this.value;
    }

    @Override
    @JsonIgnore
    public long getYear() {
        return this.value.getYear();
    }

    @Override
    @JsonIgnore
    public byte getMonth() {
        return this.value.getMonth();
    }

    @Override
    @JsonIgnore
    public byte getDay() {
        return this.value.getDay();
    }

    @Override
    @JsonIgnore
    public byte getHour() {
        return this.value.getHour();
    }

    @Override
    @JsonIgnore
    public byte getMinute() {
        return this.value.getMinute();
    }

    @Override
    @JsonIgnore
    public byte getSecond() {
        return this.value.getSecond();
    }

    @Override
    @JsonIgnore
    public String getPreferredCalendarModel() {
        return this.value.getCalendarmodel();
    }

    @Override
    @JsonIgnore
    public ItemIdValue getPreferredCalendarModelItemId() {
        return ItemIdValueImpl.fromIri(this.value.getCalendarmodel());
    }

    @Override
    @JsonIgnore
    public byte getPrecision() {
        return (byte)this.value.getPrecision();
    }

    @Override
    @JsonIgnore
    public int getTimezoneOffset() {
        return this.value.getTimezone();
    }

    @Override
    @JsonIgnore
    public int getBeforeTolerance() {
        return this.value.getBefore();
    }

    @Override
    @JsonIgnore
    public int getAfterTolerance() {
        return this.value.getAfter();
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsTimeValue(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }

    @Override
    public TimeValue toGregorian() {
        if (this.getPreferredCalendarModel().equals("http://www.wikidata.org/entity/Q1985727")) {
            return this;
        }
        if (this.getPreferredCalendarModel().equals("http://www.wikidata.org/entity/Q1985786") && this.getPrecision() >= 11 && this.value.year > Integer.MIN_VALUE && this.value.year < Integer.MAX_VALUE) {
            try {
                JulianDate julian = JulianDate.of((int)((int)this.value.year), (int)this.value.month, (int)this.value.day);
                LocalDate date = LocalDate.from((TemporalAccessor)julian);
                return new TimeValueImpl(date.getYear(), (byte)date.getMonth().getValue(), (byte)date.getDayOfMonth(), this.value.hour, this.value.minute, this.value.second, (byte)this.value.precision, this.value.before, this.value.after, this.value.timezone, "http://www.wikidata.org/entity/Q1985727");
            }
            catch (DateTimeException e) {
                return null;
            }
        }
        return null;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class JacksonInnerTime {
        private final String time;
        private final int timezone;
        private final int before;
        private final int after;
        private final int precision;
        private final String calendarmodel;
        private long year;
        private byte month;
        private byte day;
        private byte hour;
        private byte minute;
        private byte second;

        @JsonCreator
        JacksonInnerTime(@JsonProperty(value="time") String time, @JsonProperty(value="timezone") int timezone, @JsonProperty(value="before") int before, @JsonProperty(value="after") int after, @JsonProperty(value="precision") int precision, @JsonProperty(value="calendarmodel") String calendarModel) {
            this.time = time;
            this.timezone = timezone;
            this.before = before;
            this.after = after;
            this.precision = precision;
            this.calendarmodel = calendarModel;
            this.decomposeTimeString();
        }

        JacksonInnerTime(long year, byte month, byte day, byte hour, byte minute, byte second, int timezone, int before, int after, int precision, String calendarModel) {
            Validate.notNull((Object)calendarModel, (String)"Calendar model must not be null", (Object[])new Object[0]);
            this.year = year;
            this.month = month;
            this.day = day;
            this.hour = hour;
            this.minute = minute;
            this.second = second;
            this.timezone = timezone;
            this.before = before;
            this.after = after;
            this.precision = precision;
            this.calendarmodel = calendarModel;
            this.time = this.composeTimeString();
        }

        private void decomposeTimeString() {
            String[] substrings = this.time.split("(?<!\\A)[\\-:TZ]");
            this.year = Long.parseLong(substrings[0]);
            this.month = Byte.parseByte(substrings[1]);
            this.day = Byte.parseByte(substrings[2]);
            this.hour = Byte.parseByte(substrings[3]);
            this.minute = Byte.parseByte(substrings[4]);
            this.second = Byte.parseByte(substrings[5]);
        }

        private String composeTimeString() {
            return String.format("%+04d-%02d-%02dT%02d:%02d:%02dZ", this.year, this.month, this.day, this.hour, this.minute, this.second);
        }

        public String getTime() {
            return this.time;
        }

        public int getTimezone() {
            return this.timezone;
        }

        public int getBefore() {
            return this.before;
        }

        public int getAfter() {
            return this.after;
        }

        public int getPrecision() {
            return this.precision;
        }

        public String getCalendarmodel() {
            return this.calendarmodel;
        }

        @JsonIgnore
        byte getSecond() {
            return this.second;
        }

        @JsonIgnore
        byte getMinute() {
            return this.minute;
        }

        @JsonIgnore
        byte getHour() {
            return this.hour;
        }

        @JsonIgnore
        byte getDay() {
            return this.day;
        }

        @JsonIgnore
        byte getMonth() {
            return this.month;
        }

        @JsonIgnore
        long getYear() {
            return this.year;
        }
    }
}

