/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.implementation.LabeledDocumentUpdateImpl;
import org.wikidata.wdtk.datamodel.interfaces.AliasUpdate;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermedStatementDocumentUpdate;

public abstract class TermedDocumentUpdateImpl
extends LabeledDocumentUpdateImpl
implements TermedStatementDocumentUpdate {
    @JsonIgnore
    private final TermUpdate descriptions;
    @JsonIgnore
    private final Map<String, AliasUpdate> aliases;

    protected TermedDocumentUpdateImpl(EntityIdValue entityId, long revisionId, TermUpdate labels, TermUpdate descriptions, Map<String, AliasUpdate> aliases, StatementUpdate statements) {
        super(entityId, revisionId, labels, statements);
        Objects.requireNonNull(descriptions, "Description update cannot be null.");
        Objects.requireNonNull(aliases, "Alias map cannot be null.");
        for (Map.Entry<String, AliasUpdate> entry : aliases.entrySet()) {
            Validate.notBlank((CharSequence)entry.getKey(), (String)"Alias language code cannot be null or blank.", (Object[])new Object[0]);
            Objects.requireNonNull(entry.getValue(), "Alias update cannot be null.");
            if (!entry.getValue().getLanguageCode().isPresent()) continue;
            Validate.isTrue((boolean)entry.getValue().getLanguageCode().get().equals(entry.getKey()), (String)"Inconsistent alias language codes.", (Object[])new Object[0]);
        }
        this.descriptions = descriptions;
        this.aliases = Collections.unmodifiableMap(aliases.keySet().stream().filter(k -> !((AliasUpdate)aliases.get(k)).isEmpty()).collect(Collectors.toMap(k -> k, k -> (AliasUpdate)aliases.get(k))));
    }

    @Override
    @JsonIgnore
    public boolean isEmpty() {
        return super.isEmpty() && this.descriptions.isEmpty() && this.aliases.isEmpty();
    }

    @Override
    @JsonIgnore
    public TermUpdate getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    TermUpdate getJsonDescriptions() {
        return this.descriptions.isEmpty() ? null : this.descriptions;
    }

    @Override
    @JsonProperty(value="aliases")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, AliasUpdate> getAliases() {
        return this.aliases;
    }
}

