/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.implementation.EntityUpdateImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocumentUpdate;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;

public abstract class StatementDocumentUpdateImpl
extends EntityUpdateImpl
implements StatementDocumentUpdate {
    @JsonIgnore
    private final StatementUpdate statements;

    protected StatementDocumentUpdateImpl(EntityIdValue entityId, long revisionId, StatementUpdate statements) {
        super(entityId, revisionId);
        Objects.requireNonNull(statements, "Statement update cannot be null.");
        EntityIdValue subject = Stream.concat(statements.getAdded().stream(), statements.getReplaced().values().stream()).map(s -> s.getSubject()).findFirst().orElse(null);
        Validate.isTrue((subject == null || subject.equals(entityId) ? 1 : 0) != 0, (String)"Statements describe different subject.", (Object[])new Object[0]);
        this.statements = statements;
    }

    @Override
    @JsonIgnore
    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    @Override
    @JsonIgnore
    public StatementUpdate getStatements() {
        return this.statements;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    StatementUpdate getClaims() {
        return this.statements.isEmpty() ? null : this.statements;
    }
}

