/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.implementation.EntityDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementGroupImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocument;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.util.NestedIterator;

abstract class StatementDocumentImpl
extends EntityDocumentImpl
implements StatementDocument {
    protected final Map<String, List<Statement>> claims;
    private List<StatementGroup> statementGroups;

    StatementDocumentImpl(EntityIdValue id, List<StatementGroup> claims, long revisionId) {
        super(id, revisionId);
        this.claims = new HashMap<String, List<Statement>>();
        if (claims != null) {
            for (StatementGroup group : claims) {
                EntityIdValue otherId = group.getSubject();
                otherId.getIri();
                Validate.isTrue((boolean)group.getSubject().equals(id), (String)("Subject for the statement group and the document are different: " + otherId.toString() + " vs " + id.toString()), (Object[])new Object[0]);
                this.claims.put(group.getProperty().getId(), group.getStatements());
            }
        }
    }

    protected StatementDocumentImpl(EntityIdValue id, Map<String, List<Statement>> claims, long revisionId) {
        super(id, revisionId);
        this.claims = claims;
    }

    StatementDocumentImpl(@JsonProperty(value="id") String jsonId, @JsonProperty(value="claims") Map<String, List<StatementImpl.PreStatement>> claims, @JsonProperty(value="lastrevid") long revisionId, @JacksonInject(value="siteIri") String siteIri) {
        super(jsonId, revisionId, siteIri);
        if (claims != null) {
            this.claims = new HashMap<String, List<Statement>>();
            EntityIdValue subject = this.getEntityId();
            for (Map.Entry<String, List<StatementImpl.PreStatement>> entry : claims.entrySet()) {
                ArrayList<StatementImpl> statements = new ArrayList<StatementImpl>(entry.getValue().size());
                for (StatementImpl.PreStatement statement : entry.getValue()) {
                    statements.add(statement.withSubject(subject));
                }
                this.claims.put(entry.getKey(), statements);
            }
        } else {
            this.claims = Collections.emptyMap();
        }
    }

    @Override
    @JsonIgnore
    public List<StatementGroup> getStatementGroups() {
        if (this.statementGroups == null) {
            this.statementGroups = new ArrayList<StatementGroup>(this.claims.size());
            for (List<Statement> statements : this.claims.values()) {
                this.statementGroups.add(new StatementGroupImpl(statements));
            }
        }
        return this.statementGroups;
    }

    @Override
    public StatementGroup findStatementGroup(String propertyIdValue) {
        if (this.claims.containsKey(propertyIdValue)) {
            return new StatementGroupImpl(this.claims.get(propertyIdValue));
        }
        return null;
    }

    @JsonProperty(value="claims")
    public Map<String, List<Statement>> getJsonClaims() {
        return this.claims;
    }

    @Override
    @JsonIgnore
    public Iterator<Statement> getAllStatements() {
        return new NestedIterator(this.getStatementGroups());
    }

    protected static Map<String, List<Statement>> addStatementToGroups(Statement statement, Map<String, List<Statement>> claims) {
        HashMap<String, List<Statement>> newGroups = new HashMap<String, List<Statement>>(claims);
        String pid = statement.getMainSnak().getPropertyId().getId();
        if (newGroups.containsKey(pid)) {
            ArrayList<Statement> newGroup = new ArrayList<Statement>(((List)newGroups.get(pid)).size());
            boolean statementReplaced = false;
            for (Statement existingStatement : (List)newGroups.get(pid)) {
                if (existingStatement.getStatementId().equals(statement.getStatementId()) && !existingStatement.getStatementId().isEmpty()) {
                    statementReplaced = true;
                    newGroup.add(statement);
                    continue;
                }
                newGroup.add(existingStatement);
            }
            if (!statementReplaced) {
                newGroup.add(statement);
            }
            newGroups.put(pid, newGroup);
        } else {
            newGroups.put(pid, Collections.singletonList(statement));
        }
        return newGroups;
    }

    protected static Map<String, List<Statement>> removeStatements(Set<String> statementIds, Map<String, List<Statement>> claims) {
        HashMap<String, List<Statement>> newClaims = new HashMap<String, List<Statement>>(claims.size());
        for (Map.Entry<String, List<Statement>> entry : claims.entrySet()) {
            ArrayList<Statement> filteredStatements = new ArrayList<Statement>();
            for (Statement s : entry.getValue()) {
                if (statementIds.contains(s.getStatementId())) continue;
                filteredStatements.add(s);
            }
            if (filteredStatements.isEmpty()) continue;
            newClaims.put(entry.getKey(), filteredStatements);
        }
        return newClaims;
    }
}

