/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.implementation.StatementDocumentUpdateImpl;
import org.wikidata.wdtk.datamodel.interfaces.FormIdValue;
import org.wikidata.wdtk.datamodel.interfaces.FormUpdate;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermUpdate;

public class FormUpdateImpl
extends StatementDocumentUpdateImpl
implements FormUpdate {
    @JsonIgnore
    private final TermUpdate representations;
    @JsonIgnore
    private final Set<ItemIdValue> grammaticalFeatures;

    public FormUpdateImpl(FormIdValue entityId, long revisionId, TermUpdate representations, Collection<ItemIdValue> grammaticalFeatures, StatementUpdate statements) {
        super(entityId, revisionId, statements);
        Objects.requireNonNull(representations, "Representation update cannot be null.");
        if (grammaticalFeatures != null) {
            for (ItemIdValue feature : grammaticalFeatures) {
                Objects.requireNonNull(feature, "Grammatical feature cannot be null.");
                Validate.isTrue((!feature.isPlaceholder() ? 1 : 0) != 0, (String)"Grammatical feature cannot be a placeholder ID.", (Object[])new Object[0]);
            }
            Validate.isTrue((grammaticalFeatures.stream().distinct().count() == (long)grammaticalFeatures.size() ? 1 : 0) != 0, (String)"Grammatical features must be unique.", (Object[])new Object[0]);
        }
        this.representations = representations;
        this.grammaticalFeatures = grammaticalFeatures != null ? Collections.unmodifiableSet(new HashSet<ItemIdValue>(grammaticalFeatures)) : null;
    }

    @Override
    @JsonIgnore
    public FormIdValue getEntityId() {
        return (FormIdValue)super.getEntityId();
    }

    @Override
    @JsonIgnore
    public boolean isEmpty() {
        return super.isEmpty() && this.representations.isEmpty() && this.grammaticalFeatures == null;
    }

    @Override
    @JsonIgnore
    public TermUpdate getRepresentations() {
        return this.representations;
    }

    @JsonProperty(value="representations")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    TermUpdate getJsonRepresentations() {
        return this.representations.isEmpty() ? null : this.representations;
    }

    @Override
    @JsonIgnore
    public Optional<Set<ItemIdValue>> getGrammaticalFeatures() {
        return Optional.ofNullable(this.grammaticalFeatures);
    }

    @JsonProperty(value="grammaticalFeatures")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    List<String> getJsonGrammaticalFeatures() {
        if (this.grammaticalFeatures == null) {
            return null;
        }
        return this.grammaticalFeatures.stream().map(f -> f.getId()).collect(Collectors.toList());
    }

    public boolean equals(Object obj) {
        return Equality.equalsFormUpdate(this, obj);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }
}

