/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.EntityIdValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityRedirectDocument;

public class EntityRedirectDocumentImpl
implements EntityRedirectDocument {
    private final EntityIdValue entityId;
    private final EntityIdValue targetId;
    private final long revisionId;

    EntityRedirectDocumentImpl(EntityIdValue id, EntityIdValue targetId, long revisionId) {
        Validate.notNull((Object)id);
        this.entityId = id;
        Validate.notNull((Object)targetId);
        Validate.isTrue((boolean)id.getEntityType().equals(targetId.getEntityType()), (String)"You could only do redirects between entities of the same type", (Object[])new Object[0]);
        this.targetId = targetId;
        this.revisionId = revisionId;
    }

    @JsonCreator
    EntityRedirectDocumentImpl(@JsonProperty(value="entity") String jsonId, @JsonProperty(value="redirect") String jsonTargetId, @JsonProperty(value="lastrevid") long revisionId, @JacksonInject(value="siteIri") String siteIri) {
        this.entityId = EntityIdValueImpl.fromId(jsonId, siteIri);
        Validate.notNull((Object)jsonTargetId);
        this.targetId = EntityIdValueImpl.fromId(jsonTargetId, siteIri);
        Validate.isTrue((boolean)this.getEntityId().getEntityType().equals(this.targetId.getEntityType()), (String)"You could only do redirects between entities of the same type", (Object[])new Object[0]);
        this.revisionId = revisionId;
    }

    @Override
    @JsonIgnore
    public EntityIdValue getEntityId() {
        return this.entityId;
    }

    @JsonProperty(value="entity")
    String getEntityJson() {
        return this.entityId.getId();
    }

    @Override
    @JsonIgnore
    public long getRevisionId() {
        return this.revisionId;
    }

    @Override
    public EntityRedirectDocument withRevisionId(long newRevisionId) {
        return new EntityRedirectDocumentImpl(this.entityId, this.targetId, newRevisionId);
    }

    @Override
    @JsonIgnore
    public EntityIdValue getTargetId() {
        return this.targetId;
    }

    @JsonProperty(value="redirect")
    String getTargetJson() {
        return this.targetId.getId();
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsEntityRedirectDocument(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

