/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;

public class StatementUpdateBuilder {
    private final Map<String, Statement> base;
    private EntityIdValue subject;
    private final List<Statement> added = new ArrayList<Statement>();
    private final Map<String, Statement> replaced = new HashMap<String, Statement>();
    private final Set<String> removed = new HashSet<String>();

    private StatementUpdateBuilder(EntityIdValue subject, Collection<Statement> base) {
        if (subject != null) {
            Validate.isTrue((!subject.isPlaceholder() ? 1 : 0) != 0, (String)"Subject cannot be a placeholder ID.", (Object[])new Object[0]);
            this.subject = subject;
        }
        if (base != null) {
            for (Statement statement : base) {
                Objects.requireNonNull(statement, "Base document statements cannot be null.");
                Validate.isTrue((!statement.getSubject().isPlaceholder() ? 1 : 0) != 0, (String)"Statement subject cannot be a placeholder ID.", (Object[])new Object[0]);
                if (this.subject != null) {
                    Validate.isTrue((boolean)this.subject.equals(statement.getSubject()), (String)"Inconsistent statement subject.", (Object[])new Object[0]);
                } else {
                    this.subject = statement.getSubject();
                }
                Validate.notBlank((CharSequence)statement.getStatementId(), (String)"Base document statement must have valid ID.", (Object[])new Object[0]);
            }
            Validate.isTrue((base.stream().map(s -> s.getSubject()).distinct().count() <= 1L ? 1 : 0) != 0, (String)"Base document statements must all refer to the same subject.", (Object[])new Object[0]);
            Validate.isTrue((base.stream().map(s -> s.getStatementId()).distinct().count() == (long)base.size() ? 1 : 0) != 0, (String)"Base document statements must have unique IDs.", (Object[])new Object[0]);
            this.base = base.stream().collect(Collectors.toMap(s -> s.getStatementId(), s -> s));
        } else {
            this.base = null;
        }
    }

    public static StatementUpdateBuilder create() {
        return new StatementUpdateBuilder(null, null);
    }

    public static StatementUpdateBuilder create(EntityIdValue subject) {
        return new StatementUpdateBuilder(subject, null);
    }

    public static StatementUpdateBuilder forStatements(Collection<Statement> statements) {
        Objects.requireNonNull(statements, "Base document statement collection cannot be null.");
        return new StatementUpdateBuilder(null, statements);
    }

    public static StatementUpdateBuilder forStatements(EntityIdValue subject, Collection<Statement> statements) {
        Objects.requireNonNull(statements, "Base document statement collection cannot be null.");
        return new StatementUpdateBuilder(subject, statements);
    }

    public static StatementUpdateBuilder forStatementGroups(Collection<StatementGroup> groups) {
        Objects.requireNonNull(groups, "Base document statement group collection cannot be null.");
        Validate.noNullElements(groups, (String)"Base document statement groups cannot be null.", (Object[])new Object[0]);
        return new StatementUpdateBuilder(null, groups.stream().flatMap(g -> g.getStatements().stream()).collect(Collectors.toList()));
    }

    public static StatementUpdateBuilder forStatementGroups(EntityIdValue subject, Collection<StatementGroup> groups) {
        Objects.requireNonNull(groups, "Base document statement group collection cannot be null.");
        Validate.noNullElements(groups, (String)"Base document statement groups cannot be null.", (Object[])new Object[0]);
        return new StatementUpdateBuilder(subject, groups.stream().flatMap(g -> g.getStatements().stream()).collect(Collectors.toList()));
    }

    public StatementUpdateBuilder add(Statement statement) {
        Objects.requireNonNull(statement, "Statement cannot be null.");
        Validate.isTrue((!statement.getSubject().isPlaceholder() ? 1 : 0) != 0, (String)"Statement subject cannot be a placeholder ID.", (Object[])new Object[0]);
        if (this.subject != null) {
            Validate.isTrue((boolean)this.subject.equals(statement.getSubject()), (String)"Inconsistent statement subject.", (Object[])new Object[0]);
        }
        if (!statement.getStatementId().isEmpty()) {
            statement = statement.withStatementId("");
        }
        this.added.add(statement);
        if (this.subject == null) {
            this.subject = statement.getSubject();
        }
        return this;
    }

    public StatementUpdateBuilder replace(Statement statement) {
        Objects.requireNonNull(statement, "Statement cannot be null.");
        Validate.isTrue((!statement.getSubject().isPlaceholder() ? 1 : 0) != 0, (String)"Statement subject cannot be a placeholder ID.", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)statement.getStatementId(), (String)"Statement must have an ID.", (Object[])new Object[0]);
        if (this.subject != null) {
            Validate.isTrue((boolean)this.subject.equals(statement.getSubject()), (String)"Inconsistent statement subject.", (Object[])new Object[0]);
        }
        if (this.base != null) {
            Statement original = this.base.get(statement.getStatementId());
            Validate.isTrue((original != null ? 1 : 0) != 0, (String)"Replaced statement is not in base revision.", (Object[])new Object[0]);
            if (statement.equals(original)) {
                this.replaced.remove(statement.getStatementId());
                this.removed.remove(statement.getStatementId());
                return this;
            }
        }
        this.replaced.put(statement.getStatementId(), statement);
        this.removed.remove(statement.getStatementId());
        if (this.subject == null) {
            this.subject = statement.getSubject();
        }
        return this;
    }

    public StatementUpdateBuilder remove(String statementId) {
        Validate.notBlank((CharSequence)statementId, (String)"Statement ID must not be empty.", (Object[])new Object[0]);
        if (this.base != null) {
            Statement original = this.base.get(statementId);
            Validate.isTrue((original != null ? 1 : 0) != 0, (String)"Removed statement is not in base revision.", (Object[])new Object[0]);
        }
        this.removed.add(statementId);
        this.replaced.remove(statementId);
        return this;
    }

    public StatementUpdateBuilder append(StatementUpdate update) {
        Objects.requireNonNull(update, "Statement update cannot be null.");
        for (Statement statement : update.getAdded()) {
            this.add(statement);
        }
        for (Statement statement : update.getReplaced().values()) {
            this.replace(statement);
        }
        for (String statementId : update.getRemoved()) {
            this.remove(statementId);
        }
        return this;
    }

    public StatementUpdate build() {
        return Datamodel.makeStatementUpdate(this.added, this.replaced.values(), this.removed);
    }
}

