/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.helpers.TermedDocumentUpdateBuilder;
import org.wikidata.wdtk.datamodel.interfaces.AliasUpdate;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyUpdate;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermUpdate;

public class PropertyUpdateBuilder
extends TermedDocumentUpdateBuilder {
    private PropertyUpdateBuilder(PropertyIdValue propertyId, long revisionId) {
        super(propertyId, revisionId);
    }

    private PropertyUpdateBuilder(PropertyDocument revision) {
        super(revision);
    }

    public static PropertyUpdateBuilder forBaseRevisionId(PropertyIdValue propertyId, long revisionId) {
        return new PropertyUpdateBuilder(propertyId, revisionId);
    }

    public static PropertyUpdateBuilder forEntityId(PropertyIdValue propertyId) {
        return new PropertyUpdateBuilder(propertyId, 0L);
    }

    public static PropertyUpdateBuilder forBaseRevision(PropertyDocument revision) {
        return new PropertyUpdateBuilder(revision);
    }

    @Override
    PropertyIdValue getEntityId() {
        return (PropertyIdValue)super.getEntityId();
    }

    @Override
    PropertyDocument getBaseRevision() {
        return (PropertyDocument)super.getBaseRevision();
    }

    @Override
    public PropertyUpdateBuilder updateStatements(StatementUpdate update) {
        super.updateStatements(update);
        return this;
    }

    @Override
    public PropertyUpdateBuilder updateLabels(TermUpdate update) {
        super.updateLabels(update);
        return this;
    }

    @Override
    public PropertyUpdateBuilder updateDescriptions(TermUpdate update) {
        super.updateDescriptions(update);
        return this;
    }

    @Override
    public PropertyUpdateBuilder updateAliases(String language, AliasUpdate update) {
        super.updateAliases(language, update);
        return this;
    }

    public PropertyUpdateBuilder append(PropertyUpdate update) {
        super.append(update);
        return this;
    }

    @Override
    public PropertyUpdate build() {
        return Datamodel.makePropertyUpdate(this.getEntityId(), this.getBaseRevisionId(), this.labels, this.descriptions, this.aliases, this.statements);
    }
}

