package org.violet.common.swagger.service;

import com.google.auto.service.AutoService;
import org.violet.common.launch.constant.AppConstant;
import org.violet.common.launch.service.LauncherService;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.core.Ordered;

import java.util.Properties;

/***
 * 根据运行时环境自定义swagger环境配置
 * @author wjx
 * @date 2024/11/27 15:31
 */
@AutoService(LauncherService.class)
public class SwaggerLaunchServiceImpl implements LauncherService {
    @Override
    public void launcher(SpringApplicationBuilder builder, String appName, String profile) {
        //根据启动环境设置环境变量的值
        Properties props = System.getProperties();
        if (profile.equals(AppConstant.PROD_CODE)) {
            props.setProperty("swagger.enabled", "false");
            props.setProperty("knife4j.enable", "false");
            props.setProperty("knife4j.production", "true");
            props.setProperty("springdoc.api-docs.enabled", "false");
            props.setProperty("springdoc.api-usage.enabled", "false");
            props.setProperty("springdoc.swagger-ui.enabled", "false");
        } else {
            //其他环境开启swagger
            props.setProperty("swagger.enabled", "true");
            props.setProperty("knife4j.enable", "true");
            props.setProperty("knife4j.production", "false");
            props.setProperty("springdoc.api-docs.enabled", "true");
            props.setProperty("springdoc.api-usage.enabled", "true");
            props.setProperty("springdoc.swagger-ui.enabled", "true");
            props.setProperty("spring.mvc.pathmatch.matching-strategy", "ANT_PATH_MATCHER");
        }
    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }
}
