/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.mybatis.plugin;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.SystemClock;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="query", args={Statement.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class})})
public class PerformanceInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PerformanceInterceptor.class);
    private long slowSqlMillis = 1000L;
    private boolean logSql = true;
    private boolean logOnlySlowSql = true;
    private boolean printSql = true;
    private static final String SQL_FMT = "\n\u250c ID    : {sqlId}\n\u251c SQL   : {sql}\n\u251c Params: {params}\n\u2514 Type:{type},Result:{result},Times:{times}.";

    public Object intercept(Invocation invocation) throws Throwable {
        long start = SystemClock.now();
        Object result = invocation.proceed();
        long timing = SystemClock.now() - start;
        if (!this.printSql && !this.logSql) {
            return result;
        }
        boolean isSlowSql = this.slowSqlMillis > 0L && timing > this.slowSqlMillis;
        String fmtSql = this.buildSql(result, invocation, timing);
        if (this.printSql) {
            System.err.println(fmtSql);
        }
        if (this.logSql) {
            if (!this.logOnlySlowSql) {
                log.info(fmtSql);
            } else if (this.logOnlySlowSql && isSlowSql) {
                log.info(fmtSql);
            }
        }
        return result;
    }

    public String buildSql(Object result, Invocation invocation, long timing) {
        Object resultInfo = "";
        if (result != null) {
            if (result instanceof List) {
                List list = (List)result;
                resultInfo = list.size() + " rows";
            } else if (result instanceof Map) {
                Map map = (Map)result;
                resultInfo = map.size() + " rows";
            } else {
                resultInfo = result.getClass().getSimpleName();
            }
        }
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        Object target = PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)target);
        MappedStatement ms = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        BoundSql boundSql = statementHandler.getBoundSql();
        HashMap<String, Object> fmtMap = new HashMap<String, Object>();
        fmtMap.put("sqlId", ms.getId());
        fmtMap.put("sql", StrUtil.replace((CharSequence)boundSql.getSql(), (CharSequence)"\n", (CharSequence)" "));
        fmtMap.put("params", this.getParamsString(boundSql, ms));
        fmtMap.put("type", ms.getSqlCommandType().name());
        fmtMap.put("result", resultInfo);
        fmtMap.put("times", timing + "ms");
        return StrUtil.format((CharSequence)SQL_FMT, fmtMap);
    }

    public Object plugin(Object target) {
        return target instanceof StatementHandler ? Plugin.wrap((Object)target, (Interceptor)this) : target;
    }

    public void setProperties(Properties prop) {
    }

    private String getParamsString(BoundSql boundSql, MappedStatement ms) {
        List parameterMappings = boundSql.getParameterMappings();
        Object parameterObject = boundSql.getParameterObject();
        ArrayList<String> paramValuesList = new ArrayList<String>();
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = ms.getConfiguration().getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                paramValuesList.add(this.getParameterValue(parameterObject));
            } else {
                MetaObject metaObject = ms.getConfiguration().newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        paramValuesList.add(this.getParameterValue(obj));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    obj = boundSql.getAdditionalParameter(propertyName);
                    paramValuesList.add(this.getParameterValue(obj));
                }
            }
        }
        return CollUtil.join(paramValuesList, (CharSequence)",");
    }

    private String getParameterValue(Object obj) {
        Object value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            String var10000 = formatter.format(obj);
            value = "to_date('" + var10000 + "','yyyy-MM-dd hh24:mi:ss')";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value;
    }

    public PerformanceInterceptor setSlowSqlMillis(long slowSqlMillis) {
        this.slowSqlMillis = slowSqlMillis;
        return this;
    }

    public long getSlowSqlMillis() {
        return this.slowSqlMillis;
    }

    public PerformanceInterceptor setLogSql(boolean logSql) {
        this.logSql = logSql;
        return this;
    }

    public boolean isLogSql() {
        return this.logSql;
    }

    public void setLogOnlySlowSql(boolean logOnlySlowSql) {
        this.logOnlySlowSql = logOnlySlowSql;
    }

    public boolean isLogOnlySlowSql() {
        return this.logOnlySlowSql;
    }

    public void setPrintSql(boolean printSql) {
        this.printSql = printSql;
    }

    public boolean isPrintSql() {
        return this.printSql;
    }
}

