package org.violet.common.mybatis.pojo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.yulichang.wrapper.JoinAbstractWrapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;


public class PageRequest<T> implements IPage<T> {
    private List<OrderField> sorts = new ArrayList();
    public static final long DEFAULT_SIZE = 20L;
    protected long current = 1L;
    private long total = 0L;
    private long size = 20L;
    private List<T> rows = Collections.emptyList();
    private String orders;

    public PageRequest() {
    }

    public List<OrderItem> orders() {
        return new ArrayList();
    }

    @JsonIgnore
    public List<T> getRecords() {
        return this.rows;
    }

    public IPage<T> setRecords(List<T> records) {
        this.rows = records;
        return this;
    }

    public long getTotal() {
        return this.total;
    }

    public IPage<T> setTotal(long total) {
        this.total = total;
        return this;
    }

    public long getSize() {
        return this.size;
    }

    public IPage<T> setSize(long size) {
        this.size = size;
        return this;
    }

    public long getCurrent() {
        return this.current;
    }

    public IPage<T> setCurrent(long current) {
        this.current = current;
        return this;
    }

    public void setOrders(String orders) {
        this.orders = orders;
    }

    public String getOrders() {
        return this.orders;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public static PageRequest of(long currentPage, long pageSize) {
        PageRequest pageRequest = new PageRequest();
        if (currentPage > 0L) {
            pageRequest.setCurrent(currentPage);
        }

        if (pageSize > 0L) {
            pageRequest.setSize(pageSize);
        }

        return pageRequest;
    }

    public static <T> PageRequest<T> defaultPage() {
        return of(1L, 20L);
    }

    public boolean hasSorts() {
        return !CollUtil.isEmpty(this.sorts);
    }

    public void appendSortsToWrapper(AbstractWrapper queryWrapper, Function<OrderField, String> fieldNameFunc) {
        if (this.hasSorts()) {
            this.getSorts().forEach((item) -> {
                if (fieldNameFunc == null) {
                    queryWrapper.orderBy(true, item.isAsc(), item.getField(true));
                } else {
                    queryWrapper.orderBy(true, item.isAsc(), fieldNameFunc.apply(item));
                }

            });
        }

    }

    public void appendSortsToWrapper(JoinAbstractWrapper queryWrapper, Function<PageRequest.OrderField, String> fieldNameFunc) {
        if (this.hasSorts()) {
            this.getSorts().forEach((item) -> {
                if (fieldNameFunc == null) {
                    queryWrapper.orderBy(true, item.isAsc(), item.getField(true));
                } else {
                    queryWrapper.orderBy(true, item.isAsc(), (String) fieldNameFunc.apply(item));
                }

            });
        }

    }

    public void appendSortsToWrapper(AbstractWrapper queryWrapper) {
        this.appendSortsToWrapper((AbstractWrapper) queryWrapper, (Function) null);
    }

    public void appendSortsToWrapper(JoinAbstractWrapper queryWrapper) {
        this.appendSortsToWrapper((JoinAbstractWrapper) queryWrapper, (Function) null);
    }

    public void buildSorts(String sortFields, String orders) {
        if (StrUtil.isNotBlank(sortFields) && StrUtil.isNotBlank(orders)) {
            List<String> fieldList = StrUtil.split(sortFields, ',');
            final List<String> orderList = StrUtil.split(orders, ',');
            CollUtil.forEach(fieldList, new CollUtil.Consumer<String>() {
                public void accept(String field, int index) {
                    String order = (String) CollUtil.get(orderList, index);
                    PageRequest.this.addSortItem(field, order);
                }
            });
        }

    }

    public void addSortItem(String field, String order) {
        if (this.sorts == null) {
            this.sorts = new ArrayList();
        }

        if (StrUtil.isNotBlank(field) && StrUtil.isNotBlank(order)) {
            PageRequest.OrderField orderItem = new PageRequest.OrderField();
            orderItem.setField(field);
            orderItem.setAsc(StrUtil.equalsIgnoreCase(order, "asc"));
            this.sorts.add(orderItem);
        }

    }

    public List<PageRequest.OrderField> getSorts() {
        return this.sorts;
    }

    public void setSorts(final List<PageRequest.OrderField> sorts) {
        this.sorts = sorts;
    }

    public static class OrderField {
        private String field;
        private boolean asc = true;

        public OrderField() {
        }

        public String getField(boolean underline) {
            return underline ? StrUtil.toUnderlineCase(this.field) : this.field;
        }

        public String getField() {
            return this.field;
        }

        public boolean isAsc() {
            return this.asc;
        }

        public void setField(final String field) {
            this.field = field;
        }

        public void setAsc(final boolean asc) {
            this.asc = asc;
        }
    }
}