/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.launch.config.launch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.lang.Nullable;

@ConfigurationProperties(value="violet")
public class VioletProperties
implements EnvironmentAware,
EnvironmentCapable {
    @Nullable
    private Environment environment;
    private String env;
    private String name;
    private Boolean isLocal = Boolean.FALSE;
    private List<String> whiteList;
    private String rootName = "root";
    private String rootPassword = "root";
    private final Map<String, String> prop = new HashMap<String, String>();

    @Nullable
    public String get(String key) {
        return this.get(key, null);
    }

    @Nullable
    public String get(String key, @Nullable String defaultValue) {
        String value = this.prop.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Nullable
    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    @Nullable
    public Integer getInt(String key, @Nullable Integer defaultValue) {
        String value = this.prop.get(key);
        if (value != null) {
            return Integer.valueOf(value.trim());
        }
        return defaultValue;
    }

    @Nullable
    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    @Nullable
    public Long getLong(String key, @Nullable Long defaultValue) {
        String value = this.prop.get(key);
        if (value != null) {
            return Long.valueOf(value.trim());
        }
        return defaultValue;
    }

    @Nullable
    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    @Nullable
    public Boolean getBoolean(String key, @Nullable Boolean defaultValue) {
        String value = this.prop.get(key);
        if (value != null) {
            value = value.toLowerCase().trim();
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    @Nullable
    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    @Nullable
    public Double getDouble(String key, @Nullable Double defaultValue) {
        String value = this.prop.get(key);
        if (value != null) {
            return Double.parseDouble(value.trim());
        }
        return defaultValue;
    }

    public boolean isDev() {
        return "dev".equals(this.getEnv());
    }

    public boolean isProd() {
        return "prod".equals(this.getEnv());
    }

    public boolean isTest() {
        return "test".equals(this.getEnv());
    }

    public boolean containsKey(String key) {
        return this.prop.containsKey(key);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        Objects.requireNonNull(this.environment, "Spring boot \u73af\u5883\u4e0b Environment \u4e0d\u53ef\u80fd\u4e3anull");
        return this.environment;
    }

    @Generated
    public String getEnv() {
        return this.env;
    }

    @Generated
    public void setEnv(String env) {
        this.env = env;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public Boolean getIsLocal() {
        return this.isLocal;
    }

    @Generated
    public void setIsLocal(Boolean isLocal) {
        this.isLocal = isLocal;
    }

    @Generated
    public List<String> getWhiteList() {
        return this.whiteList;
    }

    @Generated
    public void setWhiteList(List<String> whiteList) {
        this.whiteList = whiteList;
    }

    @Generated
    public String getRootName() {
        return this.rootName;
    }

    @Generated
    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    @Generated
    public String getRootPassword() {
        return this.rootPassword;
    }

    @Generated
    public void setRootPassword(String rootPassword) {
        this.rootPassword = rootPassword;
    }

    @Generated
    public Map<String, String> getProp() {
        return this.prop;
    }
}

