/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.launch.config.launch;

import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class VioletEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(VioletEnvironmentPostProcessor.class);
    private final YamlPropertySourceLoader loader = new YamlPropertySourceLoader();
    private static final String DEF_YML_PATH = "classpath*:config/violet-**.yml";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        try {
            for (Resource resource : new PathMatchingResourcePatternResolver().getResources(DEF_YML_PATH)) {
                List configs = this.loader.load(resource.getFilename(), resource);
                if (configs == null || configs.isEmpty()) continue;
                environment.getPropertySources().addLast((PropertySource)configs.get(0));
            }
        }
        catch (IOException e) {
            log.error("Load module config fail", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

