/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.kingbase;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.base.Type;
import org.flywaydb.core.internal.database.kingbase.KingbaseDatabase;
import org.flywaydb.core.internal.database.kingbase.KingbaseTable;
import org.flywaydb.core.internal.database.kingbase.KingbaseType;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class KingbaseSchema
extends Schema<KingbaseDatabase, KingbaseTable> {
    protected KingbaseSchema(JdbcTemplate jdbcTemplate, KingbaseDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM pg_namespace WHERE nspname=?", new String[]{this.name}) > 0;
    }

    protected boolean doEmpty() throws SQLException {
        return !this.jdbcTemplate.queryForBoolean("SELECT EXISTS (\n    SELECT c.oid FROM pg_catalog.pg_class c\n    JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace\n    LEFT JOIN pg_catalog.pg_depend d ON d.objid = c.oid AND d.deptype = 'e'\n    WHERE  n.nspname = ? AND d.objid IS NULL AND c.relkind IN ('r', 'v', 'S', 't')\n  UNION ALL\n    SELECT t.oid FROM pg_catalog.pg_type t\n    JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace\n    LEFT JOIN pg_catalog.pg_depend d ON d.objid = t.oid AND d.deptype = 'e'\n    WHERE n.nspname = ? AND d.objid IS NULL AND t.typcategory NOT IN ('A', 'C')\n  UNION ALL\n    SELECT p.oid FROM pg_catalog.pg_proc p\n    JOIN pg_catalog.pg_namespace n ON n.oid = p.pronamespace\n    LEFT JOIN pg_catalog.pg_depend d ON d.objid = p.oid AND d.deptype = 'e'\n    WHERE n.nspname = ? AND d.objid IS NULL\n)", new String[]{this.name, this.name, this.name});
    }

    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((KingbaseDatabase)this.database).quote(new String[]{this.name}), new Object[0]);
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP SCHEMA " + ((KingbaseDatabase)this.database).quote(new String[]{this.name}) + " CASCADE", new Object[0]);
    }

    protected void doClean() throws SQLException {
        for (String statement : this.generateDropStatementsForMaterializedViews()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForViews()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (KingbaseTable table : (KingbaseTable[])this.allTables()) {
            table.drop();
        }
        for (String statement : this.generateDropStatementsForBaseTypes(true)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForRoutines()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForEnums()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForDomains()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForSequences()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForBaseTypes(false)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForExtensions()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
    }

    private List<String> generateDropStatementsForExtensions() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        if (this.extensionsTableExists()) {
            List extensionNames = this.jdbcTemplate.queryForStringList("SELECT e.extname FROM pg_extension e LEFT JOIN pg_namespace n ON n.oid = e.extnamespace LEFT JOIN pg_roles r ON r.oid = e.extowner WHERE n.nspname=? AND r.rolname=?", new String[]{this.name, ((KingbaseDatabase)this.database).doGetCurrentUser()});
            for (String extensionName : extensionNames) {
                statements.add("DROP EXTENSION IF EXISTS " + ((KingbaseDatabase)this.database).quote(new String[]{extensionName}) + " CASCADE");
            }
        }
        return statements;
    }

    private boolean extensionsTableExists() throws SQLException {
        return this.jdbcTemplate.queryForBoolean("SELECT EXISTS ( \nSELECT 1 \nFROM pg_tables \nWHERE tablename = 'pg_extension');", new String[0]);
    }

    private List<String> generateDropStatementsForSequences() throws SQLException {
        List sequenceNames = this.jdbcTemplate.queryForStringList("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema=?", new String[]{this.name});
        ArrayList<String> statements = new ArrayList<String>();
        for (String sequenceName : sequenceNames) {
            statements.add("DROP SEQUENCE IF EXISTS " + ((KingbaseDatabase)this.database).quote(new String[]{this.name, sequenceName}));
        }
        return statements;
    }

    private List<String> generateDropStatementsForBaseTypes(boolean recreate) throws SQLException {
        List rows = this.jdbcTemplate.queryForList("select typname, typcategory from pg_catalog.pg_type t left join pg_depend dep on dep.objid = t.oid and dep.deptype = 'e' where (t.typrelid = 0 OR (SELECT c.relkind = 'c' FROM pg_catalog.pg_class c WHERE c.oid = t.typrelid)) and NOT EXISTS(SELECT 1 FROM pg_catalog.pg_type el WHERE el.oid = t.typelem AND el.typarray = t.oid) and t.typnamespace in (select oid from pg_catalog.pg_namespace where nspname = ?) and dep.objid is null and t.typtype != 'd'", new Object[]{this.name});
        ArrayList<String> statements = new ArrayList<String>();
        for (Map row : rows) {
            statements.add("DROP TYPE IF EXISTS " + ((KingbaseDatabase)this.database).quote(new String[]{this.name, (String)row.get("typname")}) + " CASCADE");
        }
        if (recreate) {
            for (Map row : rows) {
                if (!Arrays.asList("P", "U").contains(row.get("typcategory"))) continue;
                statements.add("CREATE TYPE " + ((KingbaseDatabase)this.database).quote(new String[]{this.name, (String)row.get("typname")}));
            }
        }
        return statements;
    }

    private List<String> generateDropStatementsForRoutines() throws SQLException {
        String isAggregate = ((KingbaseDatabase)this.database).getVersion().isAtLeast("11") ? "pg_proc.prokind = 'a'" : "pg_proc.proisagg";
        String isProcedure = ((KingbaseDatabase)this.database).getVersion().isAtLeast("11") ? "pg_proc.prokind = 'p'" : "FALSE";
        List rows = this.jdbcTemplate.queryForList("SELECT proname, oidvectortypes(proargtypes) AS args, " + isAggregate + " as agg, " + isProcedure + " as proc FROM pg_proc INNER JOIN pg_namespace ns ON (pg_proc.pronamespace = ns.oid) LEFT JOIN pg_depend dep ON dep.objid = pg_proc.oid AND dep.deptype = 'e' WHERE ns.nspname = ? AND dep.objid IS NULL", new Object[]{this.name});
        ArrayList<String> statements = new ArrayList<String>();
        for (Map row : rows) {
            String type = "FUNCTION";
            if (this.isTrue((String)row.get("agg"))) {
                type = "AGGREGATE";
            } else if (this.isTrue((String)row.get("proc"))) {
                type = "PROCEDURE";
            }
            statements.add("DROP " + type + " IF EXISTS " + ((KingbaseDatabase)this.database).quote(new String[]{this.name, (String)row.get("proname")}) + "(" + (String)row.get("args") + ") CASCADE");
        }
        return statements;
    }

    private boolean isTrue(String agg) {
        return agg != null && agg.toLowerCase(Locale.ENGLISH).startsWith("t");
    }

    private List<String> generateDropStatementsForEnums() throws SQLException {
        List enumNames = this.jdbcTemplate.queryForStringList("SELECT t.typname FROM pg_catalog.pg_type t INNER JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace WHERE n.nspname = ? and t.typtype = 'e'", new String[]{this.name});
        ArrayList<String> statements = new ArrayList<String>();
        for (String enumName : enumNames) {
            statements.add("DROP TYPE " + ((KingbaseDatabase)this.database).quote(new String[]{this.name, enumName}));
        }
        return statements;
    }

    private List<String> generateDropStatementsForDomains() throws SQLException {
        List domainNames = this.jdbcTemplate.queryForStringList("SELECT t.typname as domain_name\nFROM pg_catalog.pg_type t\n       LEFT JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace\n       LEFT JOIN pg_depend dep ON dep.objid = t.oid AND dep.deptype = 'e'\nWHERE t.typtype = 'd'\n  AND n.nspname = ?\n  AND dep.objid IS NULL", new String[]{this.name});
        ArrayList<String> statements = new ArrayList<String>();
        for (String domainName : domainNames) {
            statements.add("DROP DOMAIN " + ((KingbaseDatabase)this.database).quote(new String[]{this.name, domainName}));
        }
        return statements;
    }

    private List<String> generateDropStatementsForMaterializedViews() throws SQLException {
        List viewNames = this.jdbcTemplate.queryForStringList("SELECT relname FROM pg_catalog.pg_class c JOIN pg_namespace n ON n.oid = c.relnamespace WHERE c.relkind = 'm' AND n.nspname = ?", new String[]{this.name});
        ArrayList<String> statements = new ArrayList<String>();
        for (String domainName : viewNames) {
            statements.add("DROP MATERIALIZED VIEW IF EXISTS " + ((KingbaseDatabase)this.database).quote(new String[]{this.name, domainName}) + " CASCADE");
        }
        return statements;
    }

    private List<String> generateDropStatementsForViews() throws SQLException {
        List viewNames = this.jdbcTemplate.queryForStringList("SELECT relname FROM pg_catalog.pg_class c JOIN pg_namespace n ON n.oid = c.relnamespace LEFT JOIN pg_depend dep ON dep.objid = c.oid AND dep.deptype = 'e' WHERE c.relkind = 'v' AND  n.nspname = ? AND dep.objid IS NULL", new String[]{this.name});
        ArrayList<String> statements = new ArrayList<String>();
        for (String domainName : viewNames) {
            statements.add("DROP VIEW IF EXISTS " + ((KingbaseDatabase)this.database).quote(new String[]{this.name, domainName}) + " CASCADE");
        }
        return statements;
    }

    protected KingbaseTable[] doAllTables() throws SQLException {
        List tableNames = this.jdbcTemplate.queryForStringList("SELECT t.table_name FROM information_schema.tables t LEFT JOIN pg_depend dep ON dep.objid = (quote_ident(t.table_schema)||'.'||quote_ident(t.table_name))::regclass::oid AND dep.deptype = 'e' WHERE table_schema=? AND table_type='BASE TABLE' AND dep.objid IS NULL AND NOT (SELECT EXISTS (SELECT inhrelid FROM pg_catalog.pg_inherits WHERE inhrelid = (quote_ident(t.table_schema)||'.'||quote_ident(t.table_name))::regclass::oid))", new String[]{this.name});
        KingbaseTable[] tables = new KingbaseTable[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new KingbaseTable(this.jdbcTemplate, (KingbaseDatabase)this.database, this, (String)tableNames.get(i));
        }
        return tables;
    }

    public Table getTable(String tableName) {
        return new KingbaseTable(this.jdbcTemplate, (KingbaseDatabase)this.database, this, tableName);
    }

    protected Type getType(String typeName) {
        return new KingbaseType(this.jdbcTemplate, (KingbaseDatabase)this.database, this, typeName);
    }
}

