/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.kingbase;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.strategy.RetryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KingbaseAdvisoryLockTemplate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KingbaseAdvisoryLockTemplate.class);
    private static final long LOCK_MAGIC_NUM = 77431708279161L;
    private final JdbcTemplate jdbcTemplate;
    private final long lockNum;

    KingbaseAdvisoryLockTemplate(JdbcTemplate jdbcTemplate, int discriminator) {
        this.jdbcTemplate = jdbcTemplate;
        this.lockNum = 77431708279161L + (long)discriminator;
    }

    public <T> T execute(Callable<T> callable) {
        RuntimeException rethrow = null;
        try {
            this.lock();
            T t = callable.call();
            return t;
        }
        catch (SQLException e) {
            rethrow = new FlywaySqlException("Unable to acquire PostgreSQL advisory lock", e);
            throw rethrow;
        }
        catch (Exception e) {
            rethrow = e instanceof RuntimeException ? (RuntimeException)e : new FlywayException((Throwable)e);
            throw rethrow;
        }
        finally {
            this.unlock(rethrow);
        }
    }

    private void lock() throws SQLException {
        RetryStrategy strategy = new RetryStrategy();
        strategy.doWithRetries(this::tryLock, "Interrupted while attempting to acquire PostgreSQL advisory lock", "Number of retries exceeded while attempting to acquire PostgreSQL advisory lock. Configure the number of retries with the 'lockRetryCount' configuration option: https://rd.gt/3A57jfk");
    }

    private boolean tryLock() throws SQLException {
        List results = this.jdbcTemplate.query("SELECT pg_try_advisory_lock(" + this.lockNum + ")", rs -> rs.getBoolean("pg_try_advisory_lock"), new Object[0]);
        return results.size() == 1 && (Boolean)results.get(0) != false;
    }

    private void unlock(RuntimeException rethrow) throws FlywaySqlException {
        try {
            boolean unlocked = this.jdbcTemplate.queryForBoolean("SELECT pg_advisory_unlock(" + this.lockNum + ")", new String[0]);
            if (!unlocked) {
                if (rethrow == null) {
                    throw new FlywayException("Unable to release PostgreSQL advisory lock");
                }
                log.error("Unable to release PostgreSQL advisory lock");
            }
        }
        catch (SQLException e) {
            if (rethrow == null) {
                throw new FlywaySqlException("Unable to release PostgreSQL advisory lock", e);
            }
            log.error("Unable to release PostgreSQL advisory lock", (Throwable)e);
        }
    }
}

