/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.datascope.config;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.violet.common.datascope.config.DataScopeProperties;
import org.violet.common.datascope.handler.DataScopeHandler;
import org.violet.common.datascope.interceptor.DataScopeInterceptor;

@AutoConfiguration
@EnableConfigurationProperties(value={DataScopeProperties.class})
public class DataScopeConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={DataScopeHandler.class})
    public DataScopeHandler dataScopeHandler() {
        return new DataScopeHandler();
    }

    @Bean
    @ConditionalOnBean(value={DataScopeHandler.class})
    @ConditionalOnMissingBean(value={DataScopeInterceptor.class})
    public DataScopeInterceptor interceptor(DataScopeHandler dataScopeHandler, DataScopeProperties dataScopeProperties) {
        return new DataScopeInterceptor(dataScopeHandler, dataScopeProperties);
    }
}

