/*
 * Decompiled with CFR 0.152.
 */
package org.violet.commom.crypto.config;

import java.util.List;
import lombok.Generated;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.violet.commom.crypto.advice.ApiDecryptParamResolver;
import org.violet.commom.crypto.config.ApiCryptoProperties;

@AutoConfiguration
@EnableConfigurationProperties(value={ApiCryptoProperties.class})
@ConditionalOnProperty(value={"violet.crypto.enabled"}, havingValue="true", matchIfMissing=true)
public class ApiCryptoConfiguration
implements WebMvcConfigurer {
    private final ApiCryptoProperties apiCryptoProperties;

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(new ApiDecryptParamResolver(this.apiCryptoProperties));
    }

    @Generated
    public ApiCryptoConfiguration(ApiCryptoProperties apiCryptoProperties) {
        this.apiCryptoProperties = apiCryptoProperties;
    }
}

