/*
 * Decompiled with CFR 0.152.
 */
package org.violet.commom.crypto.advice;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;
import org.violet.commom.crypto.annotation.decrypt.ApiDecrypt;
import org.violet.commom.crypto.bean.CryptoInfoBean;
import org.violet.commom.crypto.bean.DecryptHttpInputMessage;
import org.violet.commom.crypto.config.ApiCryptoProperties;
import org.violet.commom.crypto.exception.DecryptBodyFailException;
import org.violet.commom.crypto.util.ApiCryptoUtil;
import org.violet.common.core.util.ClassUtil;

@Order(value=1)
@AutoConfiguration
@ControllerAdvice
@ConditionalOnProperty(value={"violet.crypto.enabled"}, havingValue="true", matchIfMissing=true)
public class ApiDecryptRequestBodyAdvice
implements RequestBodyAdvice {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiDecryptRequestBodyAdvice.class);
    private final ApiCryptoProperties properties;

    public boolean supports(MethodParameter methodParameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return ClassUtil.isAnnotated((Method)methodParameter.getMethod(), ApiDecrypt.class);
    }

    public Object handleEmptyBody(Object body, @NonNull HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    @NonNull
    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        InputStream messageBody = inputMessage.getBody();
        if (messageBody.available() <= 0) {
            return inputMessage;
        }
        byte[] decryptedBody = null;
        CryptoInfoBean cryptoInfoBean = ApiCryptoUtil.getDecryptInfo(parameter);
        if (cryptoInfoBean != null) {
            byte[] bodyByteArray = StreamUtils.copyToByteArray((InputStream)messageBody);
            decryptedBody = ApiCryptoUtil.decryptData(this.properties, bodyByteArray, cryptoInfoBean);
        }
        if (decryptedBody == null) {
            throw new DecryptBodyFailException("Decryption error, please check if the selected source data is encrypted correctly. (\u89e3\u5bc6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u9009\u62e9\u7684\u6e90\u6570\u636e\u7684\u52a0\u5bc6\u65b9\u5f0f\u662f\u5426\u6b63\u786e\u3002)");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(decryptedBody);
        return new DecryptHttpInputMessage(inputStream, inputMessage.getHeaders());
    }

    @NonNull
    public Object afterBodyRead(@NonNull Object body, @NonNull HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    @Generated
    public ApiDecryptRequestBodyAdvice(ApiCryptoProperties properties) {
        this.properties = properties;
    }
}

