/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.cloud.http.restemplate;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.violet.common.cloud.feign.header.VioletFeignHeadersProperties;
import org.violet.common.cloud.http.client.OkHttp3ClientHttpRequestFactory;
import org.violet.common.cloud.http.restemplate.LbRestTemplate;
import org.violet.common.cloud.http.restemplate.RestTemplateHeaderInterceptor;
import org.violet.common.core.util.Charsets;

@AutoConfiguration
@ConditionalOnClass(value={OkHttpClient.class})
@ConditionalOnProperty(value={"violet.http.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={VioletFeignHeadersProperties.class})
public class RestTemplateConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestTemplateConfiguration.class);

    @Bean
    public RestTemplateHeaderInterceptor requestHeaderInterceptor(VioletFeignHeadersProperties properties) {
        return new RestTemplateHeaderInterceptor(properties);
    }

    private static void configMessageConverters(ApplicationContext context, List<HttpMessageConverter<?>> converters) {
        converters.removeIf(x -> x instanceof StringHttpMessageConverter || x instanceof MappingJackson2HttpMessageConverter);
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter(Charsets.UTF_8));
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter((ObjectMapper)context.getBean(ObjectMapper.class)));
    }

    @Generated
    public RestTemplateConfiguration() {
    }

    @AutoConfiguration
    @ConditionalOnClass(value={OkHttpClient.class})
    @ConditionalOnProperty(value={"violet.http.lb-rest-template.enable"})
    public static class LbRestTemplateAutoConfiguration {
        private final ApplicationContext context;

        @Bean
        @LoadBalanced
        @ConditionalOnMissingBean
        public LbRestTemplate lbRestTemplate(RestTemplateBuilder restTemplateBuilder, OkHttpClient okHttpClient) {
            restTemplateBuilder.requestFactory(() -> new OkHttp3ClientHttpRequestFactory(okHttpClient));
            LbRestTemplate restTemplate = (LbRestTemplate)restTemplateBuilder.build(LbRestTemplate.class);
            restTemplate.getInterceptors().add((ClientHttpRequestInterceptor)this.context.getBean(RestTemplateHeaderInterceptor.class));
            RestTemplateConfiguration.configMessageConverters(this.context, restTemplate.getMessageConverters());
            return restTemplate;
        }

        @Generated
        public LbRestTemplateAutoConfiguration(ApplicationContext context) {
            this.context = context;
        }
    }

    @AutoConfiguration
    @ConditionalOnClass(value={OkHttpClient.class})
    @ConditionalOnProperty(value={"violet.http.rest-template.enable"})
    public static class RestTemplateAutoConfiguration {
        private final ApplicationContext context;

        @Bean
        @ConditionalOnMissingBean
        public RestTemplate restTemplate(RestTemplateBuilder restTemplateBuilder, OkHttpClient okHttpClient) {
            restTemplateBuilder.requestFactory(() -> new OkHttp3ClientHttpRequestFactory(okHttpClient));
            RestTemplate restTemplate = restTemplateBuilder.build();
            RestTemplateConfiguration.configMessageConverters(this.context, restTemplate.getMessageConverters());
            return restTemplate;
        }

        @Generated
        public RestTemplateAutoConfiguration(ApplicationContext context) {
            this.context = context;
        }
    }
}

