/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.cloud.http;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.violet.common.cloud.feign.header.VioletFeignHeadersProperties;
import org.violet.common.cloud.http.HttpLoggingInterceptor;
import org.violet.common.cloud.http.VioHttpProperties;
import org.violet.common.cloud.http.client.OkHttpSlf4jLogger;
import org.violet.common.core.ssl.DisableValidationTrustManager;
import org.violet.common.core.ssl.TrustAllHostNames;
import org.violet.common.core.util.Holder;

@AutoConfiguration
@ConditionalOnClass(value={OkHttpClient.class})
@ConditionalOnProperty(value={"violet.http.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={VioletFeignHeadersProperties.class, VioHttpProperties.class})
public class VioletHttpAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VioletHttpAutoConfiguration.class);
    private final VioHttpProperties properties;

    @Bean
    public HttpLoggingInterceptor loggingInterceptor() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor(new OkHttpSlf4jLogger());
        interceptor.setLevel(this.properties.getLevel());
        return interceptor;
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectionPool httpClientConnectionPool() {
        int maxTotalConnections = this.properties.getMaxConnections();
        long timeToLive = this.properties.getTimeToLive();
        TimeUnit ttlUnit = this.properties.getTimeUnit();
        return new ConnectionPool(maxTotalConnections, timeToLive, ttlUnit);
    }

    @Bean
    @ConditionalOnMissingBean
    public OkHttpClient okHttpClient(ConnectionPool connectionPool, HttpLoggingInterceptor interceptor) {
        boolean followRedirects = this.properties.isFollowRedirects();
        int connectTimeout = this.properties.getConnectionTimeout();
        return this.createBuilder(this.properties.isDisableSslValidation()).connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).followRedirects(followRedirects).connectionPool(connectionPool).addInterceptor((Interceptor)interceptor).build();
    }

    private OkHttpClient.Builder createBuilder(boolean disableSslValidation) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (disableSslValidation) {
            try {
                X509TrustManager disabledTrustManager = DisableValidationTrustManager.INSTANCE;
                TrustManager[] trustManagers = new TrustManager[]{disabledTrustManager};
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustManagers, Holder.SECURE_RANDOM);
                SSLSocketFactory disabledSslSocketFactory = sslContext.getSocketFactory();
                builder.sslSocketFactory(disabledSslSocketFactory, disabledTrustManager);
                builder.hostnameVerifier((HostnameVerifier)TrustAllHostNames.INSTANCE);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                log.warn("Error setting SSLSocketFactory in OKHttpClient", (Throwable)e);
            }
        }
        return builder;
    }

    @Generated
    public VioletHttpAutoConfiguration(VioHttpProperties properties) {
        this.properties = properties;
    }
}

