/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.cloud.config;

import com.alibaba.cloud.sentinel.feign.SentinelFeignAutoConfiguration;
import com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.callback.BlockExceptionHandler;
import feign.Feign;
import feign.RequestInterceptor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.violet.common.cloud.config.VioletSentinelFilterConfiguration;
import org.violet.common.cloud.feign.VioletSentinelFeign;
import org.violet.common.cloud.feign.header.VioletFeignHeadersProperties;
import org.violet.common.cloud.feign.header.VioletFeignRequestHeaderInterceptor;
import org.violet.common.cloud.sentinel.VioletBlockExceptionHandler;

@AutoConfiguration
@Import(value={VioletSentinelFilterConfiguration.class})
@AutoConfigureBefore(value={SentinelFeignAutoConfiguration.class})
public class VioletCloudAutoConfiguration {
    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"feign.sentinel.enabled"})
    public Feign.Builder feignSentinelBuilder(RequestInterceptor requestInterceptor) {
        return VioletSentinelFeign.builder().requestInterceptor(requestInterceptor);
    }

    @Bean
    @ConditionalOnMissingBean
    public BlockExceptionHandler blockExceptionHandler() {
        return new VioletBlockExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestInterceptor requestInterceptor(VioletFeignHeadersProperties violetFeignHeadersProperties) {
        return new VioletFeignRequestHeaderInterceptor(violetFeignHeadersProperties);
    }
}

