package org.violet.common.cloud.feign.header;

import cn.dev33.satoken.same.SaSameUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.URLUtil;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import jakarta.servlet.http.HttpServletRequest;
import lombok.AllArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import java.util.Map;

/**
 * feign 传递Request header
 */
@AllArgsConstructor
public class VioletFeignRequestHeaderInterceptor implements RequestInterceptor {
    private final VioletFeignHeadersProperties properties;

    @Override
    public void apply(RequestTemplate template) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return;
        }
        HttpServletRequest request = ((ServletRequestAttributes) requestAttributes).getRequest();
        // 传递请求头
        properties.getAllowed().forEach(headerName -> {
            String header = request.getHeader(headerName);
            if (ObjectUtil.isNotEmpty(header)) {
                template.header(headerName, header);
            }
        });
//        //用于内部微服务调用鉴权
//        template.header(SaSameUtil.SAME_TOKEN, SaSameUtil.getToken());
    }

}
