package org.violet.common.bootstrap.handler;

import org.violet.common.launch.entity.JsonResult;
import org.violet.common.core.spi.PrioritySPI;
import org.violet.common.core.spi.SPIIdentify;


public interface ExceptionAdapter extends PrioritySPI {
    String[] supportExceptions();

    JsonResult adapter(Throwable e);

    default String getName() {
        return this.getClass().getSimpleName();
    }

    default SPIIdentify getIdentify() {
        return SPIIdentify.builder().name(getName()).build();
    }
}