package org.violet.common.bootstrap.config;

import lombok.AllArgsConstructor;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.aop.interceptor.SimpleAsyncUncaughtExceptionHandler;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.violet.common.core.constants.ComConst;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * 异步处理
 */
@AutoConfiguration
@EnableAsync
@EnableScheduling
@AllArgsConstructor
@EnableConfigurationProperties({
        VioletAsyncProperties.class
})
public class VioletExecutorConfiguration extends AsyncConfigurerSupport {

    private final VioletAsyncProperties violetAsyncProperties;

    @Override
    @Bean(name = ComConst.COM_ASYNC_EXECUTOR_NAME)
    public AsyncTaskExecutor getAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(violetAsyncProperties.getCorePoolSize());
        executor.setMaxPoolSize(violetAsyncProperties.getMaxPoolSize());
        executor.setQueueCapacity(violetAsyncProperties.getQueueCapacity());
        executor.setKeepAliveSeconds(violetAsyncProperties.getKeepAliveSeconds());
        executor.setThreadNamePrefix(ComConst.COM_ASYNC_EXECUTOR_NAME + "-");
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }

    @Override
    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new SimpleAsyncUncaughtExceptionHandler();
    }

}
